/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;

public class DoorSensorSwitchBlock
extends SwitchBlock {
    public DoorSensorSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    @Override
    public DoorSensorSwitchTileEntity getTe(LevelReader world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof DoorSensorSwitchTileEntity)) {
            return null;
        }
        return (DoorSensorSwitchTileEntity)te;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DoorSensorSwitchTileEntity(pos, state);
    }

    public static class DoorSensorSwitchTileEntity
    extends SwitchBlock.SwitchTileEntity {
        private int update_timer_ = 0;

        public DoorSensorSwitchTileEntity(BlockEntityType<?> te_type, BlockPos pos, BlockState state) {
            super(te_type, pos, state);
        }

        public DoorSensorSwitchTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_DOORSENSOR_SWITCH, pos, state);
        }

        @Override
        public void tick() {
            Block block;
            if (this.f_58857_.m_5776_() || --this.update_timer_ > 0) {
                return;
            }
            this.update_timer_ = 4;
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            if (state == null || !((block = state.m_60734_()) instanceof DoorSensorSwitchBlock)) {
                return;
            }
            DoorSensorSwitchBlock block2 = (DoorSensorSwitchBlock)block;
            Vec3 door_vec = Vec3.m_82528_((Vec3i)((Direction)state.m_61143_((Property)RsDirectedBlock.FACING)).m_122436_());
            AABB volume = new AABB(this.m_58899_().m_7495_()).m_82400_(0.4).m_82383_(door_vec.m_82490_(-0.5));
            boolean active = false;
            List hits = this.f_58857_.m_45976_(Player.class, volume);
            if (hits.size() > 0) {
                Vec3 door_pos = Vec3.m_82528_((Vec3i)this.m_58899_().m_121945_((Direction)state.m_61143_((Property)RsDirectedBlock.FACING)).m_7495_()).m_82520_(0.5, 0.5, 0.5);
                for (Entity e : hits) {
                    Vec3 rel_position;
                    double cos_a2;
                    Vec3 look_vec;
                    double cos_a1;
                    if (Math.abs(e.m_20154_().m_7098_()) > 0.7 || (cos_a1 = (look_vec = new Vec3(e.m_20154_().m_7096_(), 0.0, e.m_20154_().m_7094_())).m_82526_(door_vec)) < 0.5 || (cos_a2 = look_vec.m_82526_(rel_position = new Vec3(e.m_20182_().m_7096_() - door_pos.m_7096_(), 0.0, e.m_20182_().m_7094_() - door_pos.m_7094_()).m_82541_())) > -0.8) continue;
                    active = true;
                    break;
                }
            }
            if (active) {
                if (!((Boolean)state.m_61143_((Property)SwitchBlock.POWERED)).booleanValue()) {
                    block2.onSwitchActivated(this.f_58857_, this.f_58858_, state, null, null);
                    this.on_timer_reset(12);
                } else {
                    this.on_timer_reset(12);
                    this.reschedule_block_tick();
                }
            }
        }
    }
}

