/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.AutoSwitchBlock;
import wile.rsgauges.blocks.RsDirectedBlock;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Overlay;

public class EnvironmentalSensorSwitchBlock
extends AutoSwitchBlock {
    public EnvironmentalSensorSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
    }

    public EnvironmentalSensorSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, null, null);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnvironmentalSensorSwitchTileEntity(pos, state);
    }

    public static class EnvironmentalSensorSwitchTileEntity
    extends AutoSwitchBlock.AutoSwitchTileEntity {
        protected static final int debounce_max = 10;
        protected int update_interval_ = 10;
        protected double threshold0_on_ = 0.0;
        protected double threshold0_off_ = 0.0;
        protected int debounce_ = 0;
        protected int update_timer_ = 0;
        protected int debounce_counter_ = 0;

        public EnvironmentalSensorSwitchTileEntity(BlockEntityType<?> te_type, BlockPos pos, BlockState state) {
            super(te_type, pos, state);
        }

        public EnvironmentalSensorSwitchTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.TET_ENVSENSOR_SWITCH, pos, state);
        }

        public double threshold0_on() {
            return this.threshold0_on_;
        }

        public double threshold0_off() {
            return this.threshold0_off_;
        }

        public int debounce() {
            return this.debounce_;
        }

        public void threshold0_on(double v) {
            this.threshold0_on_ = v < 0.0 ? 0.0 : Math.min(v, 15.0);
        }

        public void threshold0_off(double v) {
            this.threshold0_off_ = v < 0.0 ? 0.0 : Math.min(v, 15.0);
        }

        public void debounce(int v) {
            this.debounce_ = v < 0 ? 0 : Math.min(v, 10);
        }

        @Override
        public void write(CompoundTag nbt, boolean updatePacket) {
            super.write(nbt, updatePacket);
            nbt.m_128347_("threshold0_on", this.threshold0_on());
            nbt.m_128347_("threshold0_off", this.threshold0_off());
            nbt.m_128405_("debounce", this.debounce());
        }

        @Override
        public void read(CompoundTag nbt, boolean updatePacket) {
            super.read(nbt, updatePacket);
            this.threshold0_on(nbt.m_128459_("threshold0_on"));
            this.threshold0_off(nbt.m_128459_("threshold0_off"));
            this.debounce(nbt.m_128451_("debounce"));
        }

        @Override
        public boolean activation_config(BlockState state, @Nullable Player player, double x, double y, boolean show_only) {
            int field;
            int direction;
            if (state == null) {
                return false;
            }
            SwitchBlock block = (SwitchBlock)state.m_60734_();
            int n = y >= 13.0 ? 1 : (direction = y <= 2.0 ? -1 : 0);
            int n2 = x >= 2.0 && x <= 3.95 ? 1 : (x >= 4.25 && x <= 7.0 ? 2 : (x >= 8.0 && x <= 10.0 ? 3 : (field = x >= 11.0 && x <= 13.0 ? 4 : 0)));
            if (direction == 0 || field == 0) {
                return false;
            }
            if ((block.config & 0x1000000000L) != 0L) {
                if (!show_only) {
                    switch (field) {
                        case 1: {
                            this.threshold0_on(this.threshold0_on() + (double)direction);
                            if (!(this.threshold0_off() > this.threshold0_on())) break;
                            this.threshold0_off(this.threshold0_on());
                            break;
                        }
                        case 2: {
                            this.threshold0_off(this.threshold0_off() + (double)direction);
                            if (!(this.threshold0_on() < this.threshold0_off())) break;
                            this.threshold0_on(this.threshold0_off());
                            break;
                        }
                        case 3: {
                            this.debounce(this.debounce() + direction);
                            break;
                        }
                        case 4: {
                            this.setpower(this.setpower() + direction);
                        }
                    }
                    if (this.threshold0_on() < 1.0) {
                        this.threshold0_on(1.0);
                    }
                    if (this.setpower() < 1) {
                        this.setpower(1);
                    }
                    this.m_6596_();
                }
                ArrayList<MutableComponent> tr = new ArrayList<MutableComponent>();
                MutableComponent trunit = Auxiliaries.localizable("switchconfig.lightsensor.lightunit");
                MutableComponent separator = Component.m_237113_((String)" | ");
                separator.m_130940_(ChatFormatting.GRAY);
                tr.add(Auxiliaries.localizable("switchconfig.lightsensor.threshold_on", ChatFormatting.BLUE, new Object[]{(int)this.threshold0_on(), trunit}));
                tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.lightsensor.threshold_off", ChatFormatting.YELLOW, new Object[]{(int)this.threshold0_off(), trunit})));
                tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.lightsensor.output_power", ChatFormatting.RED, new Object[]{this.setpower()})));
                if (this.debounce() > 0) {
                    tr.add(separator.m_6881_().m_7220_((Component)Auxiliaries.localizable("switchconfig.lightsensor.debounce", ChatFormatting.DARK_GREEN, new Object[]{this.debounce()})));
                } else {
                    tr.add(Component.m_237113_((String)""));
                }
                Overlay.show(player, (Component)Auxiliaries.localizable("switchconfig.lightsensor", ChatFormatting.RESET, tr.toArray()));
            } else if ((block.config & 0x6000000000L) != 0L) {
                if (!show_only) {
                    switch (field) {
                        case 4: {
                            this.setpower(this.setpower() + direction);
                        }
                    }
                    if (this.setpower() < 1) {
                        this.setpower(1);
                    }
                    this.m_6596_();
                }
                if ((block.config & 0x2000000000L) != 0L) {
                    Overlay.show(player, (Component)Auxiliaries.localizable("switchconfig.rainsensor.output_power", ChatFormatting.RED, new Object[]{this.setpower()}));
                } else {
                    Overlay.show(player, (Component)Auxiliaries.localizable("switchconfig.thundersensor.output_power", ChatFormatting.RED, new Object[]{this.setpower()}));
                }
            }
            return true;
        }

        @Override
        public void tick() {
            if (!this.m_58898_() || this.m_58904_().f_46443_ || --this.update_timer_ > 0) {
                return;
            }
            if (this.update_interval_ < 10) {
                this.update_interval_ = 10;
            }
            this.update_timer_ = this.update_interval_ + (int)(Math.random() * 5.0);
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            if (state == null || !(state.m_60734_() instanceof AutoSwitchBlock)) {
                return;
            }
            AutoSwitchBlock block = (AutoSwitchBlock)state.m_60734_();
            boolean active = (Boolean)state.m_61143_((Property)SwitchBlock.POWERED);
            if ((block.config & 0x1000000000L) != 0L) {
                if (this.threshold0_on() == 0.0 && this.threshold0_off() == 0.0) {
                    this.threshold0_on(7.0);
                    this.threshold0_off(6.0);
                } else {
                    double value = this.m_58904_().m_46803_(this.f_58858_);
                    int measurement = 0;
                    if (this.threshold0_off() >= this.threshold0_on()) {
                        measurement += value == this.threshold0_on() ? 1 : -1;
                    } else {
                        if (value >= this.threshold0_on()) {
                            measurement = 1;
                        }
                        if (value <= this.threshold0_off()) {
                            measurement = -1;
                        }
                    }
                    if (this.debounce() <= 0) {
                        if (measurement != 0) {
                            active = measurement > 0;
                        }
                        this.debounce_counter_ = 0;
                    } else {
                        this.debounce_counter_ += measurement;
                        if (this.debounce_counter_ <= 0) {
                            active = false;
                            this.debounce_counter_ = 0;
                        } else if (this.debounce_counter_ >= this.debounce_) {
                            active = true;
                            this.debounce_counter_ = this.debounce_;
                        }
                    }
                }
            } else if ((block.config & 0x2000000000L) != 0L) {
                if (state.m_61143_((Property)RsDirectedBlock.FACING) != Direction.UP && state.m_61143_((Property)RsDirectedBlock.FACING) != Direction.DOWN) {
                    this.debounce_counter_ += this.m_58904_().m_46758_(this.m_58899_().m_5484_(Direction.UP, 1)) ? 1 : -1;
                    if (this.debounce_counter_ <= 0) {
                        this.debounce_counter_ = 0;
                        active = false;
                    } else if (this.debounce_counter_ >= 4) {
                        this.debounce_counter_ = 4;
                        active = true;
                    }
                }
            } else if ((block.config & 0x4000000000L) != 0L) {
                this.debounce_counter_ += this.m_58904_().m_46470_() && (this.m_58904_().m_46758_(this.m_58899_()) || this.m_58904_().m_46758_(this.m_58899_().m_5484_(Direction.UP, 20))) ? 1 : -1;
                if (this.debounce_counter_ <= 0) {
                    this.debounce_counter_ = 0;
                    active = false;
                } else if (this.debounce_counter_ >= 4) {
                    this.debounce_counter_ = 4;
                    active = true;
                }
            }
            this.updateSwitchState(state, block, active, this.configured_on_time());
        }
    }
}

