/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import wile.rsgauges.blocks.SwitchBlock;
import wile.rsgauges.detail.ModResources;

public class LinkSenderSwitchBlock
extends SwitchBlock {
    private final boolean is_analog;

    public LinkSenderSwitchBlock(long config, BlockBehaviour.Properties properties, AABB unrotatedBBUnpowered, @Nullable AABB unrotatedBBPowered, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound, boolean analog_device) {
        super(config, properties, unrotatedBBUnpowered, unrotatedBBPowered, powerOnSound, powerOffSound);
        this.is_analog = analog_device;
    }

    @Override
    public boolean switchLinkHasAnalogSupport(Level world, BlockPos pos) {
        return this.is_analog;
    }

    @Override
    protected int getPower(BlockState state, BlockGetter world, BlockPos pos, Direction side, boolean strong) {
        return 0;
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        SwitchBlock.SwitchTileEntity te = this.getTe((LevelReader)world, pos);
        if (te != null) {
            te.reset((LevelReader)world);
        }
        world.m_7731_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 27);
        this.m_6861_(state, world, pos, state.m_60734_(), pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()), false);
    }

    @Override
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        int power;
        if (!this.isAffectedByNeigbour(state, (LevelAccessor)world, pos, fromPos)) {
            return;
        }
        SwitchBlock.SwitchTileEntity te = this.getTe((LevelReader)world, pos);
        if (te == null) {
            return;
        }
        if (this.isCube()) {
            power = world.m_277086_(pos);
        } else {
            Direction facing = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
            BlockPos neighbour_pos = pos.m_121945_(facing);
            BlockState neighbour_state = world.m_8055_(neighbour_pos);
            power = !state.m_60803_() ? world.m_277086_(neighbour_pos) : Math.max(neighbour_state.m_60746_((BlockGetter)world, neighbour_pos, facing), neighbour_state.m_60775_((BlockGetter)world, neighbour_pos, facing));
        }
        if ((this.config & 0x100000L) != 0L && te.inverted()) {
            power = 15 - power;
        }
        if (te.setpower() == power) {
            return;
        }
        te.setpower(power);
        boolean powered = power > 0;
        boolean was_powered = (Boolean)state.m_61143_((Property)POWERED);
        if (powered != was_powered && ((this.config & 0x20000000L) == 0L || powered && !was_powered)) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 27);
            if ((this.config & 0x20000000L) != 0L) {
                te.on_timer_reset();
                te.on_timer_extend();
                te.reschedule_block_tick();
            }
            if (powered && this.power_on_sound != null) {
                this.power_on_sound.play(world, pos);
            } else if (!powered && this.power_off_sound != null) {
                this.power_off_sound.play(world, pos);
            }
        }
        if (!te.activateSwitchLinks(power, powered ? 15 : 0, powered != was_powered)) {
            ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
        }
    }

    public boolean getWeakChanges(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }
}

