/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.rsgauges.libmc.detail.Auxiliaries;
import wile.rsgauges.libmc.detail.Networking;

public abstract class RsBlock
extends Block
implements EntityBlock {
    public static final long RSBLOCK_CONFIG_SOLID = 0L;
    public static final long RSBLOCK_CONFIG_CUTOUT = 0x1000000000000000L;
    public static final long RSBLOCK_CONFIG_CUTOUT_MIPPED = 0x2000000000000000L;
    public static final long RSBLOCK_CONFIG_TRANSLUCENT = 0x3000000000000000L;
    public static final long RSBLOCK_NOT_WATERLOGGABLE = 0x8000000000000L;
    private static final RenderTypeHint[] render_layer_map_ = new RenderTypeHint[]{RenderTypeHint.SOLID, RenderTypeHint.CUTOUT, RenderTypeHint.CUTOUT_MIPPED, RenderTypeHint.TRANSLUCENT};
    public final long config;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public RsBlock(long config, BlockBehaviour.Properties properties) {
        this(config, properties, Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0));
    }

    public RsBlock(long config, BlockBehaviour.Properties properties, AABB aabb) {
        this(config, properties, Shapes.m_83064_((AABB)aabb));
    }

    public RsBlock(long config, BlockBehaviour.Properties properties, VoxelShape vshape) {
        super(properties);
        this.config = config;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderTypeHint getRenderTypeHint() {
        return render_layer_map_[(int)(this.config >> 60 & 3L)];
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> te_type) {
        return world.f_46443_ ? null : (w, p, s, te) -> ((RsTileEntity)te).tick();
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_214009_(ServerLevel p_221121_, T te) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCustomBreakingProgress(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter source, BlockPos pos, CollisionContext selectionContext) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.m_5940_(state, world, pos, selectionContext);
    }

    public boolean m_48673_(BlockState state) {
        return false;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fs;
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        state = (this.config & 0x8000000000000L) == 0L ? (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf((fs = context.m_43725_().m_6425_(context.m_8083_())).m_76152_() == Fluids.f_76193_)) : (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return (this.config & 0x8000000000000L) == 0L ? (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state)) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        if ((this.config & 0x8000000000000L) == 0L && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return false;
        }
        return super.m_7420_(state, reader, pos);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        world.m_46717_(pos, newState.m_60734_());
        world.m_46672_(pos, newState.m_60734_());
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if ((this.config & 0x8000000000000L) == 0L && ((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return Collections.singletonList(new ItemStack((ItemLike)state.m_60734_().m_5456_()));
    }

    public void m_6256_(BlockState state, Level world, BlockPos pos, Player player) {
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
    }

    public static enum RenderTypeHint {
        SOLID,
        CUTOUT,
        CUTOUT_MIPPED,
        TRANSLUCENT;

    }

    public static abstract class RsTileEntity
    extends BlockEntity
    implements Networking.IPacketTileNotifyReceiver {
        private static final int NBT_ENTITY_TYPE = 1;

        public RsTileEntity(BlockEntityType<?> te_type, BlockPos pos, BlockState state) {
            super(te_type, pos, state);
        }

        public void write(CompoundTag nbt, boolean updatePacket) {
        }

        public void read(CompoundTag nbt, boolean updatePacket) {
        }

        public void tick() {
        }

        protected final void syncToClients() {
            if (this.f_58857_.m_5776_()) {
                return;
            }
            CompoundTag nbt = new CompoundTag();
            this.write(nbt, true);
            Networking.PacketTileNotifyServerToClient.sendToPlayers(this, nbt);
        }

        @Override
        public final void onServerPacketReceived(CompoundTag nbt) {
            this.read(nbt, true);
        }

        public final void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.write(nbt, false);
        }

        public final void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.read(nbt, false);
        }
    }
}

