/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.IPlantable;
import wile.rsgauges.libmc.detail.Auxiliaries;

public class BlockCategories {
    private static final String MODID = "rsgauges";
    private static final Matcher filter_none = (w, p) -> false;
    private static final Map<String, Matcher> matchers_ = new HashMap<String, Matcher>();
    private static final List<String> matcher_names_;

    public static final void update() {
    }

    public static final Matcher getMatcher(String name) {
        return matchers_.getOrDefault(name, filter_none);
    }

    public static final List<String> getMatcherNames() {
        return matcher_names_;
    }

    static {
        matchers_.put("any", (w, p) -> {
            BlockState st = w.m_8055_(p);
            return !st.m_60795_();
        });
        matchers_.put("solid", (w, p) -> w.m_8055_(p).m_280296_());
        matchers_.put("liquid", (w, p) -> w.m_8055_(p).m_278721_() || !w.m_6425_(p).m_76178_());
        matchers_.put("air", (w, p) -> w.m_8055_(p).m_60795_());
        matchers_.put("plant", (w, p) -> {
            Block b = w.m_8055_(p).m_60734_();
            return b instanceof GrowingPlantBlock || b instanceof IPlantable || Auxiliaries.isInBlockTag(b, new ResourceLocation(MODID, "plants"));
        });
        matchers_.put("material_wood", (w, p) -> Auxiliaries.isInBlockTag(w.m_8055_(p).m_60734_(), new ResourceLocation(MODID, "wooden")));
        matchers_.put("material_stone", (w, p) -> Auxiliaries.isInBlockTag(w.m_8055_(p).m_60734_(), new ResourceLocation(MODID, "stone_like")));
        matchers_.put("material_glass", (w, p) -> Auxiliaries.isInBlockTag(w.m_8055_(p).m_60734_(), new ResourceLocation(MODID, "glass_like")));
        matchers_.put("material_clay", (w, p) -> Auxiliaries.isInBlockTag(w.m_8055_(p).m_60734_(), new ResourceLocation(MODID, "clay_like")));
        matchers_.put("material_water", (w, p) -> {
            BlockState st = w.m_8055_(p);
            Block b = st.m_60734_();
            if (Auxiliaries.isInBlockTag(b, new ResourceLocation(MODID, "water_like"))) {
                return true;
            }
            if (st.m_60819_().m_76178_()) {
                return false;
            }
            return st.m_60819_().m_76152_() == Fluids.f_76193_ || st.m_60819_().m_76152_() == Fluids.f_76192_;
        });
        matchers_.put("ore", (w, p) -> Auxiliaries.isInBlockTag(w.m_8055_(p).m_60734_(), new ResourceLocation(MODID, "ores")));
        matchers_.put("woodlog", (w, p) -> Auxiliaries.isInBlockTag(w.m_8055_(p).m_60734_(), new ResourceLocation(MODID, "logs")));
        matchers_.put("crop", (w, p) -> {
            Block b = w.m_8055_(p).m_60734_();
            return b instanceof CropBlock || Auxiliaries.isInBlockTag(b, new ResourceLocation(MODID, "crops"));
        });
        matchers_.put("crop_mature", (w, p) -> {
            BlockState s = w.m_8055_(p);
            Block b = s.m_60734_();
            return b instanceof CropBlock && ((CropBlock)b).m_52307_(s) || b == Blocks.f_50186_ || b == Blocks.f_50133_;
        });
        matchers_.put("sapling", (w, p) -> Auxiliaries.isInBlockTag(w.m_8055_(p).m_60734_(), new ResourceLocation(MODID, "saplings")));
        matchers_.put("soil", (w, p) -> Auxiliaries.isInBlockTag(w.m_8055_(p).m_60734_(), new ResourceLocation(MODID, "soils")));
        matchers_.put("fertile", (w, p) -> w.m_8055_(p).m_60734_().isFertile(w.m_8055_(p), (BlockGetter)w, p));
        matchers_.put("planks", (w, p) -> Auxiliaries.isInBlockTag(w.m_8055_(p).m_60734_(), new ResourceLocation(MODID, "planks")));
        matchers_.put("slab", (w, p) -> Auxiliaries.isInBlockTag(w.m_8055_(p).m_60734_(), new ResourceLocation(MODID, "slabs")));
        matcher_names_ = new ArrayList<String>();
        matcher_names_.add("any");
        matcher_names_.add("solid");
        matcher_names_.add("liquid");
        matcher_names_.add("air");
        matcher_names_.add("plant");
        matcher_names_.add("material_wood");
        matcher_names_.add("material_stone");
        matcher_names_.add("material_glass");
        matcher_names_.add("material_clay");
        matcher_names_.add("material_water");
        matcher_names_.add("ore");
        matcher_names_.add("woodlog");
        matcher_names_.add("crop");
        matcher_names_.add("crop_mature");
        matcher_names_.add("sapling");
        matcher_names_.add("soil");
        matcher_names_.add("fertile");
        matcher_names_.add("planks");
        matcher_names_.add("slab");
        matchers_.forEach((k, v) -> {
            if (!matcher_names_.contains(k)) {
                matcher_names_.add((String)k);
            }
        });
    }

    public static interface Matcher {
        public boolean match(Level var1, BlockPos var2);
    }
}

