/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.circles;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import com.mojang.datafixers.util.Pair;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;

public interface ICircleComponent {
    public ControlFlow acceptControlFlow(CastingImage var1, CircleCastEnv var2, Direction var3, BlockPos var4, BlockState var5, ServerLevel var6);

    @Contract(pure=true)
    public boolean canEnterFromDirection(Direction var1, BlockPos var2, BlockState var3, ServerLevel var4);

    @Contract(pure=true)
    public EnumSet<Direction> possibleExitDirections(BlockPos var1, BlockState var2, Level var3);

    @Contract(pure=true)
    default public Pair<BlockPos, Direction> exitPositionFromDirection(BlockPos pos, Direction dir) {
        return Pair.of((Object)pos.m_7918_(dir.m_122429_(), dir.m_122430_(), dir.m_122431_()), (Object)dir);
    }

    public BlockState startEnergized(BlockPos var1, BlockState var2, Level var3);

    public boolean isEnergized(BlockPos var1, BlockState var2, Level var3);

    public BlockState endEnergized(BlockPos var1, BlockState var2, Level var3);

    public static void sfx(BlockPos pos, BlockState bs, Level world, BlockEntityAbstractImpetus impetus, boolean success2) {
        Vec3 vpos;
        Vec3 vecOutDir;
        UUID activator = Util.f_137441_;
        if (impetus != null && impetus.getExecutionState() != null && impetus.getExecutionState().caster != null) {
            activator = impetus.getExecutionState().caster;
        }
        FrozenPigment colorizer = impetus == null || impetus.getExecutionState() == null ? new FrozenPigment(new ItemStack((ItemLike)HexItems.DYE_PIGMENTS.get(DyeColor.RED)), activator) : impetus.getPigment();
        Block block = bs.m_60734_();
        if (block instanceof BlockCircleComponent) {
            BlockCircleComponent bcc = (BlockCircleComponent)block;
            Direction outDir = bcc.normalDir(pos, bs, world);
            float height = bcc.particleHeight(pos, bs, world);
            vecOutDir = new Vec3(outDir.m_253071_());
            vpos = Vec3.m_82512_((Vec3i)pos).m_82549_(vecOutDir.m_82490_((double)height));
        } else {
            vpos = Vec3.m_82512_((Vec3i)pos);
            vecOutDir = new Vec3(0.0, 0.0, 0.0);
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            ParticleSpray spray = new ParticleSpray(vpos, vecOutDir.m_82490_(success2 ? 1.0 : 1.5), success2 ? 0.1 : 0.5, (float)Math.PI / (float)(success2 ? 4 : 2), success2 ? 30 : 100);
            spray.sprayParticles(serverLevel, success2 ? colorizer : new FrozenPigment(new ItemStack((ItemLike)HexItems.DYE_PIGMENTS.get(DyeColor.RED)), activator));
        }
        float pitch = 1.0f;
        SoundEvent sound = HexSounds.SPELL_CIRCLE_FAIL;
        if (success2 && impetus != null) {
            sound = HexSounds.SPELL_CIRCLE_FIND_BLOCK;
            CircleExecutionState state = impetus.getExecutionState();
            int note = state.reachedPositions.size() - 1;
            int semitone = impetus.semitoneFromScale(note);
            pitch = (float)Math.pow(2.0, (double)(semitone - 8) / 12.0);
        }
        world.m_6263_(null, vpos.f_82479_, vpos.f_82480_, vpos.f_82481_, sound, SoundSource.BLOCKS, 1.0f, pitch);
    }

    default public void fakeThrowMishap(BlockPos pos, BlockState bs, CastingImage image, CircleCastEnv env, Mishap mishap) {
        Mishap.Context errorCtx = new Mishap.Context(null, (Component)bs.m_60734_().m_49954_().m_130946_(" (").m_7220_((Component)Component.m_237113_((String)pos.m_123344_())).m_130946_(")"));
        OperatorSideEffect.DoMishap sideEffect = new OperatorSideEffect.DoMishap(mishap, errorCtx);
        CastingVM vm = new CastingVM(image, env);
        sideEffect.performEffect(vm);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class ControlFlow {

        public static final class Stop
        extends ControlFlow {
        }

        public static final class Continue
        extends ControlFlow {
            public final CastingImage update;
            public final List<Pair<BlockPos, Direction>> exits;

            public Continue(CastingImage update, List<Pair<BlockPos, Direction>> exits) {
                this.update = update;
                this.exits = exits;
            }
        }
    }
}

