/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.iota;

import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.ResolvedPatternType;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.hex.HexEvalSounds;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;

public class ContinuationIota
extends Iota {
    public static final Component DISPLAY = Component.m_237115_((String)"hexcasting.tooltip.jump_iota").m_130940_(ChatFormatting.RED);
    public static IotaType<ContinuationIota> TYPE = new IotaType<ContinuationIota>(){

        @Override
        @NotNull
        public ContinuationIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            CompoundTag compoundTag = (CompoundTag)HexUtils.downcast(tag, CompoundTag.f_128326_);
            return new ContinuationIota(SpellContinuation.fromNBT(compoundTag, world));
        }

        @Override
        public Component display(Tag tag) {
            return DISPLAY;
        }

        @Override
        public int color() {
            return -3407872;
        }
    };

    public ContinuationIota(SpellContinuation cont) {
        super(HexIotaTypes.CONTINUATION, cont);
    }

    public SpellContinuation getContinuation() {
        return (SpellContinuation)this.payload;
    }

    @Override
    public boolean isTruthy() {
        return true;
    }

    @Override
    public boolean toleratesOther(Iota that) {
        ContinuationIota cont;
        return ContinuationIota.typesMatch(this, that) && that instanceof ContinuationIota && (cont = (ContinuationIota)that).getContinuation().equals(this.getContinuation());
    }

    @Override
    @NotNull
    public Tag serialize() {
        return this.getContinuation().serializeToNBT();
    }

    @Override
    @NotNull
    public CastResult execute(CastingVM vm, ServerLevel world, SpellContinuation continuation) {
        return new CastResult(this, this.getContinuation(), vm.getImage(), List.of(), ResolvedPatternType.EVALUATED, HexEvalSounds.HERMES);
    }

    @Override
    public boolean executable() {
        return true;
    }

    @Override
    public int size() {
        SpellContinuation continuation = this.getContinuation();
        int size = 0;
        while (continuation instanceof SpellContinuation.NotDone) {
            SpellContinuation.NotDone notDone = (SpellContinuation.NotDone)continuation;
            ++size;
            size += notDone.component1().size();
            continuation = notDone.component2();
        }
        return Math.min(size, 1);
    }
}

