/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.math;

import at.petrak.hexcasting.api.casting.math.HexDir;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0002 !B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0000J\u0011\u0010\u0016\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0014H\u0086\u0002J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u001a2\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0014J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\""}, d2={"Lat/petrak/hexcasting/api/casting/math/HexCoord;", "", "q", "", "r", "(II)V", "getQ", "()I", "getR", "component1", "component2", "copy", "delta", "x", "distanceTo", "equals", "", "other", "hashCode", "immediateDelta", "Lat/petrak/hexcasting/api/casting/math/HexDir;", "neighbor", "minus", "plus", "d", "rangeAround", "", "radius", "s", "shiftedBy", "toString", "", "Companion", "RingIter", "hexcasting-forge-1.20.1"})
public final class HexCoord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int q;
    private final int r;
    @NotNull
    private static final HexCoord Origin = new HexCoord(0, 0);

    public HexCoord(int q, int r) {
        this.q = q;
        this.r = r;
    }

    public final int getQ() {
        return this.q;
    }

    public final int getR() {
        return this.r;
    }

    public final int s() {
        return -this.q - this.r;
    }

    @NotNull
    public final HexCoord shiftedBy(@NotNull HexCoord x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return new HexCoord(this.q + x.q, this.r + x.r);
    }

    @NotNull
    public final HexCoord shiftedBy(@NotNull HexDir d) {
        Intrinsics.checkNotNullParameter((Object)((Object)d), (String)"d");
        return this.shiftedBy(d.asDelta());
    }

    @NotNull
    public final HexCoord delta(@NotNull HexCoord x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return new HexCoord(this.q - x.q, this.r - x.r);
    }

    @NotNull
    public final HexCoord plus(@NotNull HexCoord x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return this.shiftedBy(x);
    }

    @NotNull
    public final HexCoord plus(@NotNull HexDir d) {
        Intrinsics.checkNotNullParameter((Object)((Object)d), (String)"d");
        return this.shiftedBy(d);
    }

    @NotNull
    public final HexCoord minus(@NotNull HexCoord x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return this.delta(x);
    }

    public final int distanceTo(@NotNull HexCoord x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return (Math.abs(this.q - x.q) + Math.abs(this.q + this.r - x.q - x.r) + Math.abs(this.r - x.r)) / 2;
    }

    @NotNull
    public final Iterator<HexCoord> rangeAround(int radius) {
        return new RingIter(this, radius);
    }

    @Nullable
    public final HexDir immediateDelta(@NotNull HexCoord neighbor) {
        Intrinsics.checkNotNullParameter((Object)neighbor, (String)"neighbor");
        HexCoord hexCoord = neighbor.minus(this);
        return Intrinsics.areEqual((Object)hexCoord, (Object)new HexCoord(1, 0)) ? HexDir.EAST : (Intrinsics.areEqual((Object)hexCoord, (Object)new HexCoord(0, 1)) ? HexDir.SOUTH_EAST : (Intrinsics.areEqual((Object)hexCoord, (Object)new HexCoord(-1, 1)) ? HexDir.SOUTH_WEST : (Intrinsics.areEqual((Object)hexCoord, (Object)new HexCoord(-1, 0)) ? HexDir.WEST : (Intrinsics.areEqual((Object)hexCoord, (Object)new HexCoord(0, -1)) ? HexDir.NORTH_WEST : (Intrinsics.areEqual((Object)hexCoord, (Object)new HexCoord(1, -1)) ? HexDir.NORTH_EAST : null)))));
    }

    public final int component1() {
        return this.q;
    }

    public final int component2() {
        return this.r;
    }

    @NotNull
    public final HexCoord copy(int q, int r) {
        return new HexCoord(q, r);
    }

    public static /* synthetic */ HexCoord copy$default(HexCoord hexCoord, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = hexCoord.q;
        }
        if ((n3 & 2) != 0) {
            n2 = hexCoord.r;
        }
        return hexCoord.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "HexCoord(q=" + this.q + ", r=" + this.r + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.q);
        result = result * 31 + Integer.hashCode(this.r);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HexCoord)) {
            return false;
        }
        HexCoord hexCoord = (HexCoord)other;
        if (this.q != hexCoord.q) {
            return false;
        }
        return this.r == hexCoord.r;
    }

    @NotNull
    public static final HexCoord getOrigin() {
        return Companion.getOrigin();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\t\u0010\u0014\u001a\u00020\u0002H\u0096\u0002R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/api/casting/math/HexCoord$RingIter;", "", "Lat/petrak/hexcasting/api/casting/math/HexCoord;", "center", "radius", "", "(Lat/petrak/hexcasting/api/casting/math/HexCoord;I)V", "getCenter", "()Lat/petrak/hexcasting/api/casting/math/HexCoord;", "q", "getQ", "()I", "setQ", "(I)V", "r", "getR", "setR", "getRadius", "hasNext", "", "next", "hexcasting-forge-1.20.1"})
    private static final class RingIter
    implements Iterator<HexCoord>,
    KMappedMarker {
        @NotNull
        private final HexCoord center;
        private final int radius;
        private int q;
        private int r;

        public RingIter(@NotNull HexCoord center, int radius) {
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            this.center = center;
            this.radius = radius;
            this.q = -this.radius;
            this.r = Math.max(-this.radius, 0);
        }

        @NotNull
        public final HexCoord getCenter() {
            return this.center;
        }

        public final int getRadius() {
            return this.radius;
        }

        public final int getQ() {
            return this.q;
        }

        public final void setQ(int n) {
            this.q = n;
        }

        public final int getR() {
            return this.r;
        }

        public final void setR(int n) {
            this.r = n;
        }

        @Override
        public boolean hasNext() {
            return this.r <= this.radius + Math.min(0, -this.q) || this.q < this.radius;
        }

        @Override
        @NotNull
        public HexCoord next() {
            if (this.r > this.radius + Math.min(0, -this.q)) {
                int n = this.q;
                this.q = n + 1;
                this.r = -this.radius + Math.max(0, -this.q);
            }
            HexCoord out = new HexCoord(this.center.getQ() + this.q, this.center.getR() + this.r);
            int n = this.r;
            this.r = n + 1;
            return out;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lat/petrak/hexcasting/api/casting/math/HexCoord$Companion;", "", "()V", "Origin", "Lat/petrak/hexcasting/api/casting/math/HexCoord;", "getOrigin$annotations", "getOrigin", "()Lat/petrak/hexcasting/api/casting/math/HexCoord;", "hexcasting-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HexCoord getOrigin() {
            return Origin;
        }

        @JvmStatic
        public static /* synthetic */ void getOrigin$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

