/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.mod;

import at.petrak.hexcasting.api.HexAPI;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;

public class HexConfig {
    private static CommonConfigAccess common = null;
    private static ClientConfigAccess client = null;
    private static ServerConfigAccess server = null;

    public static boolean anyMatch(List<? extends String> keys, ResourceLocation key) {
        for (String string : keys) {
            ResourceLocation rl;
            if (!ResourceLocation.m_135830_((String)string) || !(rl = new ResourceLocation(string)).equals((Object)key)) continue;
            return true;
        }
        return false;
    }

    public static boolean noneMatch(List<? extends String> keys, ResourceLocation key) {
        return !HexConfig.anyMatch(keys, key);
    }

    public static boolean anyMatchResLoc(List<? extends ResourceLocation> keys, ResourceLocation key) {
        return keys.stream().anyMatch(arg_0 -> ((ResourceLocation)key).equals(arg_0));
    }

    public static CommonConfigAccess common() {
        return common;
    }

    public static ClientConfigAccess client() {
        return client;
    }

    public static ServerConfigAccess server() {
        return server;
    }

    public static void setCommon(CommonConfigAccess access) {
        if (common != null) {
            HexAPI.LOGGER.warn("CommonConfigAccess was replaced! Old {} New {}", (Object)common.getClass().getName(), (Object)access.getClass().getName());
        }
        common = access;
    }

    public static void setClient(ClientConfigAccess access) {
        if (client != null) {
            HexAPI.LOGGER.warn("ClientConfigAccess was replaced! Old {} New {}", (Object)client.getClass().getName(), (Object)access.getClass().getName());
        }
        client = access;
    }

    public static void setServer(ServerConfigAccess access) {
        if (server != null) {
            HexAPI.LOGGER.warn("ServerConfigAccess was replaced! Old {} New {}", (Object)server.getClass().getName(), (Object)access.getClass().getName());
        }
        server = access;
    }

    public static interface CommonConfigAccess {
        public static final long DEFAULT_DUST_MEDIA_AMOUNT = 10000L;
        public static final long DEFAULT_SHARD_MEDIA_AMOUNT = 50000L;
        public static final long DEFAULT_CHARGED_MEDIA_AMOUNT = 100000L;
        public static final double DEFAULT_MEDIA_TO_HEALTH_RATE = 10000.0;
        public static final int DEFAULT_CYPHER_COOLDOWN = 8;
        public static final int DEFAULT_TRINKET_COOLDOWN = 5;
        public static final int DEFAULT_ARTIFACT_COOLDOWN = 3;

        public long dustMediaAmount();

        public long shardMediaAmount();

        public long chargedCrystalMediaAmount();

        public double mediaToHealthRate();

        public int cypherCooldown();

        public int trinketCooldown();

        public int artifactCooldown();
    }

    public static interface ClientConfigAccess {
        public static final boolean DEFAULT_CTRL_TOGGLES_OFF_STROKE_ORDER = false;
        public static final boolean DEFAULT_INVERT_SPELLBOOK_SCROLL = false;
        public static final boolean DEFAULT_INVERT_ABACUS_SCROLL = false;
        public static final double DEFAULT_GRID_SNAP_THRESHOLD = 0.5;
        public static final boolean DEFAULT_CLICKING_TOGGLES_DRAWING = false;

        public boolean ctrlTogglesOffStrokeOrder();

        public boolean invertSpellbookScrollDirection();

        public boolean invertAbacusScrollDirection();

        public double gridSnapThreshold();

        public boolean clickingTogglesDrawing();
    }

    public static interface ServerConfigAccess {
        public static final int DEFAULT_MAX_OP_COUNT = 100000;
        public static final int DEFAULT_MAX_SPELL_CIRCLE_LENGTH = 1024;
        public static final int DEFAULT_OP_BREAK_HARVEST_LEVEL = 3;
        public static final boolean DEFAULT_VILLAGERS_DISLIKE_MIND_MURDER = true;
        public static final List<String> DEFAULT_DIM_TP_DENYLIST = List.of("twilightforest:twilight_forest");
        public static final boolean DEFAULT_TRUE_NAME_HAS_AMBIT = true;

        public int opBreakHarvestLevelBecauseForgeThoughtItWasAGoodIdeaToImplementHarvestTiersUsingAnHonestToGodTopoSort();

        public int maxOpCount();

        public int maxSpellCircleLength();

        public boolean isActionAllowed(ResourceLocation var1);

        public boolean isActionAllowedInCircles(ResourceLocation var1);

        public boolean doVillagersTakeOffenseAtMindMurder();

        public boolean canTeleportInThisDimension(ResourceKey<Level> var1);

        public boolean trueNameHasAmbit();

        default public Tier opBreakHarvestLevel() {
            return switch (this.opBreakHarvestLevelBecauseForgeThoughtItWasAGoodIdeaToImplementHarvestTiersUsingAnHonestToGodTopoSort()) {
                case 0 -> Tiers.WOOD;
                case 1 -> Tiers.STONE;
                case 2 -> Tiers.IRON;
                case 3 -> Tiers.DIAMOND;
                case 4 -> Tiers.NETHERITE;
                default -> throw new RuntimeException("please only return a value in 0<=x<=4");
            };
        }
    }
}

