/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.client.render.HexPatternLike;
import at.petrak.hexcasting.client.render.HexPatternPoints;
import at.petrak.hexcasting.client.render.PatternColors;
import at.petrak.hexcasting.client.render.PatternSettings;
import at.petrak.hexcasting.client.render.PatternTextureManager;
import at.petrak.hexcasting.client.render.RenderLib;
import at.petrak.hexcasting.client.render.VCDrawHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PatternRenderer {
    private static final float outerZ = 5.0E-4f;
    private static final float innerZ = 0.001f;

    public static void renderPattern(HexPattern pattern, PoseStack ps, PatternSettings patSets, PatternColors patColors, double seed, int resPerUnit) {
        PatternRenderer.renderPattern(pattern, ps, null, patSets, patColors, seed, resPerUnit);
    }

    public static void renderPattern(HexPattern pattern, PoseStack ps, @Nullable WorldlyBits worldlyBits, PatternSettings patSets, PatternColors patColors, double seed, int resPerUnit) {
        PatternRenderer.renderPattern(HexPatternLike.of(pattern), ps, worldlyBits, patSets, patColors, seed, resPerUnit);
    }

    public static void renderPattern(HexPatternLike patternlike, PoseStack ps, @Nullable WorldlyBits worldlyBits, PatternSettings patSets, PatternColors patColors, double seed, int resPerUnit) {
        boolean didRender;
        ShaderInstance oldShader = RenderSystem.getShader();
        HexPatternPoints staticPoints = HexPatternPoints.getStaticPoints(patternlike, patSets, seed);
        boolean shouldRenderDynamic = true;
        if (patSets.getSpeed() == 0.0f && PatternTextureManager.useTextures && patColors.innerStartColor() == patColors.innerEndColor() && patColors.outerStartColor() == patColors.outerEndColor() && (didRender = PatternRenderer.renderPatternTexture(patternlike, ps, worldlyBits, patSets, patColors, seed, resPerUnit))) {
            shouldRenderDynamic = false;
        }
        if (shouldRenderDynamic) {
            Object zappyPattern;
            if (patSets.getSpeed() == 0.0f) {
                zappyPattern = staticPoints.zappyPoints;
            } else {
                List<Vec2> nonzappyLines = patternlike.getNonZappyPoints();
                Set<Integer> dupIndices = RenderLib.findDupIndices(nonzappyLines);
                zappyPattern = RenderLib.makeZappy(nonzappyLines, dupIndices, patSets.getHops(), patSets.getVariance(), patSets.getSpeed(), patSets.getFlowIrregular(), patSets.getReadabilityOffset(), patSets.getLastSegmentProp(), seed);
            }
            List<Vec2> zappyRenderSpace = staticPoints.scaleVecs((List<Vec2>)zappyPattern);
            if (FastColor.ARGB32.m_13655_((int)patColors.outerEndColor()) != 0 && FastColor.ARGB32.m_13655_((int)patColors.outerStartColor()) != 0) {
                RenderLib.drawLineSeq(ps.m_85850_().m_252922_(), zappyRenderSpace, (float)patSets.getOuterWidth(staticPoints.finalScale), patColors.outerStartColor(), patColors.outerEndColor(), VCDrawHelper.getHelper(worldlyBits, ps, 5.0E-4f));
            }
            if (FastColor.ARGB32.m_13655_((int)patColors.innerEndColor()) != 0 && FastColor.ARGB32.m_13655_((int)patColors.innerStartColor()) != 0) {
                RenderLib.drawLineSeq(ps.m_85850_().m_252922_(), zappyRenderSpace, (float)patSets.getInnerWidth(staticPoints.finalScale), patColors.innerStartColor(), patColors.innerEndColor(), VCDrawHelper.getHelper(worldlyBits, ps, 0.001f));
            }
        }
        float dotZ = 0.0011f;
        if (FastColor.ARGB32.m_13655_((int)patColors.startingDotColor()) != 0) {
            RenderLib.drawSpot(ps.m_85850_().m_252922_(), (Vec2)staticPoints.dotsScaled.get(0), (float)patSets.getStartDotRadius(staticPoints.finalScale), patColors.startingDotColor(), VCDrawHelper.getHelper(worldlyBits, ps, dotZ));
        }
        if (FastColor.ARGB32.m_13655_((int)patColors.gridDotsColor()) != 0) {
            for (int i = 1; i < staticPoints.dotsScaled.size(); ++i) {
                Vec2 gridDot = (Vec2)staticPoints.dotsScaled.get(i);
                RenderLib.drawSpot(ps.m_85850_().m_252922_(), gridDot, (float)patSets.getGridDotsRadius(staticPoints.finalScale), patColors.gridDotsColor(), VCDrawHelper.getHelper(worldlyBits, ps, dotZ));
            }
        }
        RenderSystem.setShader(() -> oldShader);
    }

    private static boolean renderPatternTexture(HexPatternLike patternlike, PoseStack ps, @Nullable WorldlyBits worldlyBits, PatternSettings patSets, PatternColors patColors, double seed, int resPerUnit) {
        int cl;
        VertexConsumer vc;
        VCDrawHelper vcHelper;
        Optional<Map<String, ResourceLocation>> maybeTextures = PatternTextureManager.getTextures(patternlike, patSets, seed, resPerUnit);
        if (maybeTextures.isEmpty()) {
            return false;
        }
        Map<String, ResourceLocation> textures = maybeTextures.get();
        HexPatternPoints staticPoints = HexPatternPoints.getStaticPoints(patternlike, patSets, seed);
        if (FastColor.ARGB32.m_13655_((int)patColors.outerStartColor()) != 0) {
            vcHelper = VCDrawHelper.getHelper(worldlyBits, ps, 5.0E-4f, textures.get("outer"));
            vc = vcHelper.vcSetupAndSupply(VertexFormat.Mode.QUADS);
            cl = patColors.outerStartColor();
            vcHelper.vertex(vc, cl, new Vec2(0.0f, 0.0f), new Vec2(0.0f, 0.0f), ps.m_85850_().m_252922_());
            vcHelper.vertex(vc, cl, new Vec2(0.0f, (float)staticPoints.fullHeight), new Vec2(0.0f, 1.0f), ps.m_85850_().m_252922_());
            vcHelper.vertex(vc, cl, new Vec2((float)staticPoints.fullWidth, (float)staticPoints.fullHeight), new Vec2(1.0f, 1.0f), ps.m_85850_().m_252922_());
            vcHelper.vertex(vc, cl, new Vec2((float)staticPoints.fullWidth, 0.0f), new Vec2(1.0f, 0.0f), ps.m_85850_().m_252922_());
            vcHelper.vcEndDrawer(vc);
        }
        if (FastColor.ARGB32.m_13655_((int)patColors.innerStartColor()) != 0) {
            vcHelper = VCDrawHelper.getHelper(worldlyBits, ps, 0.001f, textures.get("inner"));
            vc = vcHelper.vcSetupAndSupply(VertexFormat.Mode.QUADS);
            cl = patColors.innerStartColor();
            vcHelper.vertex(vc, cl, new Vec2(0.0f, 0.0f), new Vec2(0.0f, 0.0f), ps.m_85850_().m_252922_());
            vcHelper.vertex(vc, cl, new Vec2(0.0f, (float)staticPoints.fullHeight), new Vec2(0.0f, 1.0f), ps.m_85850_().m_252922_());
            vcHelper.vertex(vc, cl, new Vec2((float)staticPoints.fullWidth, (float)staticPoints.fullHeight), new Vec2(1.0f, 1.0f), ps.m_85850_().m_252922_());
            vcHelper.vertex(vc, cl, new Vec2((float)staticPoints.fullWidth, 0.0f), new Vec2(1.0f, 0.0f), ps.m_85850_().m_252922_());
            vcHelper.vcEndDrawer(vc);
        }
        return true;
    }

    public static boolean shouldDoStrokeGradient() {
        return Screen.m_96637_();
    }

    public record WorldlyBits(@Nullable MultiBufferSource provider, Integer light, Vec3 normal) {
    }
}

