/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.msgs;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.msgs.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.phys.Vec3;

public record MsgBeepS2C(Vec3 target, int note, NoteBlockInstrument instrument) implements IMessage
{
    public static final ResourceLocation ID = HexAPI.modLoc("beep");

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static MsgBeepS2C deserialize(ByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        int note = buf.readInt();
        NoteBlockInstrument instrument = (NoteBlockInstrument)buf.m_130066_(NoteBlockInstrument.class);
        return new MsgBeepS2C(new Vec3(x, y, z), note, instrument);
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.writeDouble(this.target.f_82479_);
        buf.writeDouble(this.target.f_82480_);
        buf.writeDouble(this.target.f_82481_);
        buf.writeInt(this.note);
        buf.m_130068_((Enum)this.instrument);
    }

    public static void handle(final MsgBeepS2C msg) {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                Minecraft minecraft = Minecraft.m_91087_();
                ClientLevel world = minecraft.f_91073_;
                if (world != null) {
                    float pitch = (float)Math.pow(2.0, (double)(msg.note() - 12) / 12.0);
                    world.m_7785_(msg.target().f_82479_, msg.target().f_82480_, msg.target().f_82481_, (SoundEvent)msg.instrument().m_263188_().m_203334_(), SoundSource.PLAYERS, 3.0f, pitch, false);
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, msg.target().f_82479_, msg.target().f_82480_ + 0.2, msg.target().f_82481_, (double)msg.note() / 24.0, 0.0, 0.0);
                }
            }
        });
    }
}

