/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient.brainsweep;

import at.petrak.hexcasting.common.recipe.ingredient.brainsweep.EntityTagIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.brainsweep.EntityTypeIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.brainsweep.VillagerIngredient;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class BrainsweepeeIngredient {
    public abstract boolean test(Entity var1, ServerLevel var2);

    public abstract Component getName();

    public abstract List<Component> getTooltip(boolean var1);

    public abstract JsonObject serialize();

    public void wrapWrite(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.ingrType());
        this.write(buf);
    }

    public abstract void write(FriendlyByteBuf var1);

    @Nullable
    public abstract Entity exampleEntity(Level var1);

    public abstract Type ingrType();

    public abstract String getSomeKindOfReasonableIDForEmi();

    public static BrainsweepeeIngredient read(FriendlyByteBuf buf) {
        Type type = (Type)buf.m_130066_(Type.class);
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.VILLAGER -> VillagerIngredient.read(buf);
            case Type.ENTITY_TYPE -> EntityTypeIngredient.read(buf);
            case Type.ENTITY_TAG -> EntityTagIngredient.read(buf);
        };
    }

    public static BrainsweepeeIngredient deserialize(JsonObject json) {
        String typestr = GsonHelper.m_13906_((JsonObject)json, (String)"type");
        Type type = Type.valueOf(typestr.toUpperCase(Locale.ROOT));
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.VILLAGER -> VillagerIngredient.deserialize(json);
            case Type.ENTITY_TYPE -> EntityTypeIngredient.deserialize(json);
            case Type.ENTITY_TAG -> EntityTagIngredient.deserialize(json);
        };
    }

    public static Component getModNameComponent(String namespace) {
        String mod = IXplatAbstractions.INSTANCE.getModName(namespace);
        return Component.m_237113_((String)mod).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC});
    }

    public static enum Type implements StringRepresentable
    {
        VILLAGER,
        ENTITY_TYPE,
        ENTITY_TAG;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

