/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.cap;

import at.petrak.hexcasting.forge.network.MsgAltioraUpdateAck;
import at.petrak.hexcasting.forge.network.MsgPigmentUpdateAck;
import at.petrak.hexcasting.forge.network.MsgSentinelStatusUpdateAck;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CapSyncers {
    @SubscribeEvent
    public static void copyDataOnDeath(PlayerEvent.Clone evt) {
        Player eitherSidePlayer = evt.getEntity();
        if (!(eitherSidePlayer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)eitherSidePlayer;
        Player eitherSideProto = evt.getOriginal();
        if (!(eitherSideProto instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer proto = (ServerPlayer)eitherSideProto;
        IXplatAbstractions x = IXplatAbstractions.INSTANCE;
        x.setFlight(player, x.getFlight(proto));
        x.setAltiora((Player)player, x.getAltiora((Player)proto));
        x.setSentinel((Player)player, x.getSentinel((Player)proto));
        x.setPigment((Player)player, x.getPigment((Player)proto));
        x.setStaffcastImage(player, x.getStaffcastVM(proto, InteractionHand.MAIN_HAND).getImage());
        x.setPatterns(player, x.getPatternsSavedInUi(proto));
    }

    @SubscribeEvent
    public static void syncDataOnLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        CapSyncers.syncSentinel(player2);
        CapSyncers.syncPigment(player2);
        CapSyncers.syncAltiora(player2);
    }

    @SubscribeEvent
    public static void syncDataOnRejoin(PlayerEvent.PlayerRespawnEvent evt) {
        Player player = evt.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        CapSyncers.syncSentinel(player2);
        CapSyncers.syncPigment(player2);
        CapSyncers.syncAltiora(player2);
    }

    public static void syncSentinel(ServerPlayer player) {
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgSentinelStatusUpdateAck(IXplatAbstractions.INSTANCE.getSentinel((Player)player)));
    }

    public static void syncPigment(ServerPlayer player) {
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgPigmentUpdateAck(IXplatAbstractions.INSTANCE.getPigment((Player)player)));
    }

    public static void syncAltiora(ServerPlayer player) {
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgAltioraUpdateAck(IXplatAbstractions.INSTANCE.getAltiora((Player)player)));
    }
}

