/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.interop.jei;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.client.ClientTickCounter;
import at.petrak.hexcasting.client.render.RenderLib;
import at.petrak.hexcasting.common.recipe.BrainsweepRecipe;
import at.petrak.hexcasting.forge.interop.jei.HexJEIPlugin;
import at.petrak.hexcasting.forge.interop.jei.PatternDrawable;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BrainsweepRecipeCategory
implements IRecipeCategory<BrainsweepRecipe> {
    public static final ResourceLocation UID = HexAPI.modLoc("brainsweep");
    private final IDrawableStatic background;
    private final IDrawable icon;
    private final Component localizedName;

    public BrainsweepRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = HexAPI.modLoc("textures/gui/brainsweep_jei.png");
        this.background = guiHelper.drawableBuilder(location, 0, 0, 118, 86).setTextureSize(128, 128).build();
        ResourceLocation brainsweep = HexAPI.modLoc("brainsweep");
        this.localizedName = Component.m_237115_((String)("hexcasting.action." + brainsweep));
        this.icon = new PatternDrawable(brainsweep, 16, 16);
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull BrainsweepRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (37.0 <= mouseX && mouseX <= 63.0 && 19.0 <= mouseY && mouseY <= 67.0) {
            Minecraft mc = Minecraft.m_91087_();
            return recipe.entityIn().getTooltip(mc.f_91066_.f_92125_);
        }
        return Collections.emptyList();
    }

    public void draw(@NotNull BrainsweepRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            Entity example = recipe.entityIn().exampleEntity((Level)level);
            if (example == null) {
                return;
            }
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderLib.renderEntity(graphics, example, (Level)level, 50.0f, 62.5f, ClientTickCounter.getTotal(), 20.0f, 0.0f);
        }
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull BrainsweepRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 12, 35).addItemStacks(recipe.blockIn().getDisplayedStacks());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 87, 35).addItemStack(new ItemStack((ItemLike)recipe.result().m_60734_()));
    }

    @NotNull
    public RecipeType<BrainsweepRecipe> getRecipeType() {
        return HexJEIPlugin.BRAINSWEEPING;
    }
}

