/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.interop.patchouli;

import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.interop.patchouli.AbstractPatternComponent;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import vazkii.patchouli.api.IVariable;

public class ManualPatternComponent
extends AbstractPatternComponent {
    @SerializedName(value="patterns")
    public String patternsRaw;
    @SerializedName(value="stroke_order")
    public String strokeOrderRaw;
    protected transient boolean strokeOrder;

    @Override
    public List<HexPattern> getPatterns(UnaryOperator<IVariable> lookup) {
        this.strokeOrder = ((IVariable)lookup.apply(IVariable.wrap((String)this.strokeOrderRaw))).asBoolean(true);
        List patsRaw = ((IVariable)lookup.apply(IVariable.wrap((String)this.patternsRaw))).asListOrSingleton();
        ArrayList<HexPattern> out = new ArrayList<HexPattern>();
        for (IVariable ivar : patsRaw) {
            JsonElement json = ivar.unwrap();
            AbstractPatternComponent.RawPattern raw = (AbstractPatternComponent.RawPattern)new Gson().fromJson(json, AbstractPatternComponent.RawPattern.class);
            HexDir dir = HexDir.fromString(raw.startdir);
            HexPattern pat = HexPattern.fromAngles(raw.signature, dir);
            out.add(pat);
        }
        return out;
    }

    @Override
    public boolean showStrokeOrder() {
        return this.strokeOrder;
    }

    @Override
    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.strokeOrder = IVariable.wrap((String)this.strokeOrderRaw).asBoolean(true);
        super.onVariablesAvailable(lookup);
    }
}

