/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="cable_facades", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CFConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> BLOCK_STRINGS = BUILDER.comment("List of blocks that are allowed to be covered. Supports '*' as a wildcard.").defineListAllowEmpty("blocks", List.of("pipez:*_pipe", "mekanism:*_cable", "mekanism:*_conductor", "mekanism:*_pipe", "mekanism:*_tube", "mekanism:*_transporter", "mekanism_extras:*_cable", "mekanism_extras:*_conductor", "mekanism_extras:*_pipe", "mekanism_extras:*_tube", "mekanism_extras:*_transporter", "thermal:*_duct", "thermal:*_duct_windowed", "computercraft:cable", "powah:energy_cable_*", "create:fluid_pipe", "pneumaticcraft:*_tube", "ppfluids:fluid_pipe", "prettypipes:pipe", "laserio:laser_*", "cyclic:*_pipe", "embers:*_pipe", "embers:item_extractor", "elementalcraft:elementpipe*", "gtceu:*wire", "gtceu:*pipe"), CFConfig::validateBlockName);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> NOT_ALLOWED_BLOCK_STRINGS = BUILDER.comment("List of blocks that are explicitly not allowed to be used as a cover. Supports '*' as a wildcard.").defineListAllowEmpty("not_allowed_blocks", List.of(), CFConfig::validateBlockName);
    private static final ForgeConfigSpec.BooleanValue CONSUME_FACADE = BUILDER.comment("Whether the facade should be consumed when placed.").define("consumeFacade", true);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    private static final Map<Block, Boolean> allowedBlocks = new HashMap<Block, Boolean>();
    private static final Map<Block, Boolean> disallowedBlocks = new HashMap<Block, Boolean>();
    private static final List<Pattern> blockPatterns = new ArrayList<Pattern>();
    private static final List<Pattern> notAllowedBlockPatterns = new ArrayList<Pattern>();
    public static boolean consumeFacade;

    private static boolean validateBlockName(Object obj) {
        if (obj instanceof String) {
            String blockName = (String)obj;
            if (blockName.contains("*")) {
                return true;
            }
            return ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockName));
        }
        return false;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        Block block;
        String regex;
        consumeFacade = (Boolean)CONSUME_FACADE.get();
        allowedBlocks.clear();
        disallowedBlocks.clear();
        blockPatterns.clear();
        notAllowedBlockPatterns.clear();
        for (String blockName : (List)BLOCK_STRINGS.get()) {
            if (blockName.contains("*")) {
                regex = blockName.replace("*", ".*");
                blockPatterns.add(Pattern.compile(regex));
                continue;
            }
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
            if (block == null) continue;
            allowedBlocks.put(block, true);
        }
        for (String blockName : (List)NOT_ALLOWED_BLOCK_STRINGS.get()) {
            if (blockName.contains("*")) {
                regex = blockName.replace("*", ".*");
                notAllowedBlockPatterns.add(Pattern.compile(regex));
                continue;
            }
            block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
            if (block == null) continue;
            disallowedBlocks.put(block, true);
        }
    }

    public static boolean isBlockAllowed(Block targetBlock) {
        Boolean cached = allowedBlocks.get(targetBlock);
        if (cached != null) {
            return cached;
        }
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)targetBlock);
        if (blockId != null) {
            String blockIdString = blockId.toString();
            for (Pattern pattern : blockPatterns) {
                if (!pattern.matcher(blockIdString).matches()) continue;
                allowedBlocks.put(targetBlock, true);
                return true;
            }
        }
        allowedBlocks.put(targetBlock, false);
        return false;
    }

    public static boolean isBlockDisallowed(Block targetBlock) {
        Boolean cached = disallowedBlocks.get(targetBlock);
        if (cached != null) {
            return cached;
        }
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)targetBlock);
        if (blockId != null) {
            String blockIdString = blockId.toString();
            for (Pattern pattern : notAllowedBlockPatterns) {
                if (!pattern.matcher(blockIdString).matches()) continue;
                disallowedBlocks.put(targetBlock, true);
                return true;
            }
        }
        disallowedBlocks.put(targetBlock, false);
        return false;
    }
}

