/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.content.items;

import com.portingdeadmods.cable_facades.CFConfig;
import com.portingdeadmods.cable_facades.CFMain;
import com.portingdeadmods.cable_facades.events.ClientFacadeManager;
import com.portingdeadmods.cable_facades.events.ClientStuff;
import com.portingdeadmods.cable_facades.registries.CFItemTags;
import com.portingdeadmods.cable_facades.registries.CFItems;
import com.portingdeadmods.cable_facades.utils.FacadeUtils;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class FacadeItem
extends Item {
    public static final String FACADE_BLOCK = "facade_block";

    public FacadeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        if (p_41432_.m_5776_()) {
            CFMain.LOGGER.debug("Facades: {}", ClientFacadeManager.FACADED_BLOCKS);
            CFMain.LOGGER.debug("Loaded: {}", ClientFacadeManager.LOADED_BLOCKS);
        }
        return super.m_7203_(p_41432_, p_41433_, p_41434_);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack itemStack = context.m_43722_();
        if (!level.m_5776_() && itemStack.m_41782_() && !FacadeUtils.hasFacade((BlockGetter)level, pos)) {
            CompoundTag tag = itemStack.m_41783_();
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(tag.m_128461_(FACADE_BLOCK)));
            Block targetBlock = context.m_43725_().m_8055_(pos).m_60734_();
            boolean noFacadeTag = context.m_43725_().m_8055_(pos).m_204343_().noneMatch(blockTagKey -> blockTagKey.equals(CFItemTags.SUPPORTS_FACADE));
            if (!CFConfig.isBlockAllowed(targetBlock) && noFacadeTag) {
                return InteractionResult.FAIL;
            }
            if (targetBlock == block || CFConfig.isBlockDisallowed(block)) {
                if (targetBlock == block) {
                    context.m_43723_().m_5661_((Component)Component.m_237113_((String)"Cannot facade block with itself").m_130940_(ChatFormatting.RED), true);
                } else {
                    context.m_43723_().m_5661_((Component)Component.m_237113_((String)"This block cannot be used as a cover (disabled by config)").m_130940_(ChatFormatting.RED), true);
                }
                return InteractionResult.FAIL;
            }
            FacadeUtils.addFacade(level, pos, block);
            if (!context.m_43723_().m_7500_() && CFConfig.consumeFacade) {
                itemStack.m_41774_(1);
            }
        }
        FacadeUtils.updateBlocks(level, pos);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public Component m_7626_(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            CompoundTag tag = itemStack.m_41783_();
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(tag.m_128461_(FACADE_BLOCK)));
            BlockItem blockItem = (BlockItem)block.m_5456_();
            return Component.m_237113_((String)("Facade - " + blockItem.m_41466_().getString()));
        }
        return Component.m_237113_((String)"Facade - Empty");
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ClientStuff.FACADE_ITEM_RENDERER;
            }
        });
    }

    public ItemStack createFacade(Block block) {
        ItemStack facadeStack = new ItemStack((ItemLike)CFItems.FACADE.get());
        CompoundTag nbtData = new CompoundTag();
        nbtData.m_128359_(FACADE_BLOCK, BuiltInRegistries.f_256975_.m_7981_((Object)block).toString());
        facadeStack.m_41751_(nbtData);
        return facadeStack;
    }
}

