/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.portingdeadmods.cable_facades.events.ClientFacadeManager;
import com.portingdeadmods.cable_facades.mixins.LevelRendererAccess;
import com.portingdeadmods.cable_facades.registries.CFItems;
import com.portingdeadmods.cable_facades.registries.CFRenderTypes;
import com.portingdeadmods.cable_facades.utils.FacadeUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="cable_facades", value={Dist.CLIENT})
public final class GameClientEvents {
    private static float facadeTransparency = 1.0f;
    private static final RenderType FACADE_RENDER_TYPE = new RenderType("cable_facades:facades", DefaultVertexFormat.f_85811_, VertexFormat.Mode.QUADS, 131072, true, true, () -> {
        RenderType.m_110466_().m_110185_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)facadeTransparency);
    }, () -> {
        RenderType.m_110466_().m_110188_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }){};
    private static final RandomSource RANDOM = RandomSource.m_216327_();

    @SubscribeEvent
    public static void render(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        Map<BlockPos, @Nullable Block> chunkFacades = ClientFacadeManager.FACADED_BLOCKS;
        if (chunkFacades == null || chunkFacades.isEmpty()) {
            return;
        }
        Frustum frustum = event.getFrustum();
        List<Map.Entry> visibleFacades = chunkFacades.entrySet().stream().filter(entry -> {
            if (entry == null) {
                return false;
            }
            BlockPos pos = (BlockPos)entry.getKey();
            if (pos == null) {
                return false;
            }
            AABB boundingBox = new AABB(pos);
            return frustum.m_113029_(boundingBox);
        }).toList();
        if (visibleFacades.isEmpty()) {
            return;
        }
        facadeTransparency = mc.f_91074_.m_21205_().m_150930_((Item)CFItems.WRENCH.get()) ? 0.5f : 1.0f;
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        VertexConsumer buffer = bufferSource.m_6299_(FACADE_RENDER_TYPE);
        ClientLevel level = mc.f_91073_;
        Vec3 cameraPos = event.getCamera().m_90583_();
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        for (Map.Entry entry2 : visibleFacades) {
            BlockPos pos = (BlockPos)entry2.getKey();
            Block facadeBlock = (Block)entry2.getValue();
            if (pos == null || facadeBlock == null) continue;
            BlockState facadeState = facadeBlock.m_49966_();
            BlockRenderDispatcher blockRenderer = mc.m_91289_();
            BakedModel facadeModel = blockRenderer.m_110910_(facadeState);
            ModelData modelData = facadeModel.getModelData((BlockAndTintGetter)level, pos, facadeState, ModelData.EMPTY);
            poseStack.m_85836_();
            poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            blockRenderer.renderBatched(facadeState, pos, (BlockAndTintGetter)level, poseStack, buffer, true, RANDOM, modelData, null);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        bufferSource.m_109912_(FACADE_RENDER_TYPE);
    }

    @SubscribeEvent
    public static void renderOutline(RenderHighlightEvent.Block event) {
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Level world = living.m_9236_();
            BlockHitResult rtr = event.getTarget();
            BlockPos pos = rtr.m_82425_();
            Vec3 renderView = event.getCamera().m_90583_();
            BlockState targetBlock = world.m_8055_(rtr.m_82425_());
            if (FacadeUtils.hasFacade((BlockGetter)world, pos)) {
                ((LevelRendererAccess)event.getLevelRenderer()).callRenderHitOutline(event.getPoseStack(), event.getMultiBufferSource().m_6299_(CFRenderTypes.LINES_NONTRANSLUCENT), (Entity)living, renderView.f_82479_, renderView.f_82480_, renderView.f_82481_, pos, targetBlock);
                event.setCanceled(true);
            }
        }
    }

    public static void loadChunk(ChunkEvent.Load event) {
    }
}

