/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.events;

import com.portingdeadmods.cable_facades.content.items.FacadeItem;
import com.portingdeadmods.cable_facades.data.CableFacadeSavedData;
import com.portingdeadmods.cable_facades.data.helper.ChunkFacadeMap;
import com.portingdeadmods.cable_facades.networking.CFMessages;
import com.portingdeadmods.cable_facades.networking.s2c.AddFacadedBlocksPacket;
import com.portingdeadmods.cable_facades.networking.s2c.RemoveFacadedBlocksPacket;
import com.portingdeadmods.cable_facades.registries.CFItemTags;
import com.portingdeadmods.cable_facades.registries.CFItems;
import com.portingdeadmods.cable_facades.utils.FacadeUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cable_facades")
public final class GameEvents {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        String msgReceived = "cable_facades_update_message_received";
        if (!player.getPersistentData().m_128471_(msgReceived)) {
            player.m_213846_((Component)Component.m_237113_((String)"*Cable-Facades Update*").m_130940_(ChatFormatting.RED));
            player.m_213846_((Component)Component.m_237113_((String)"This update will delete all previously placed facades because we changed the way facades are saved. We apologize for this inconvenience. This is the last time this will happen. On the bright side, the mod's overall performance should be a lot better now."));
            player.getPersistentData().m_128379_(msgReceived, true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Level level = event.getPlayer().m_9236_();
        BlockPos pos = event.getPos();
        Player player = event.getPlayer();
        if (!level.m_5776_() && FacadeUtils.hasFacade((BlockGetter)level, pos)) {
            Block facade = FacadeUtils.getFacade((BlockGetter)level, pos);
            FacadeUtils.removeFacade(level, pos);
            if (!player.m_7500_()) {
                ItemStack facadeStack = ((FacadeItem)((Object)CFItems.FACADE.get())).createFacade(facade);
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)facadeStack);
            }
            event.setCanceled(true);
        }
        FacadeUtils.updateBlocks(level, pos);
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Block facadeBlock = FacadeUtils.getFacade((BlockGetter)level, pos);
        if (player.m_6144_() && player.m_21205_().m_204117_(CFItemTags.WRENCHES) && facadeBlock != null) {
            if (!level.m_5776_()) {
                FacadeUtils.removeFacade(level, pos);
                if (!player.m_7500_()) {
                    ItemStack facadeStack = ((FacadeItem)((Object)CFItems.FACADE.get())).createFacade(facadeBlock);
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)facadeStack);
                } else {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
                }
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            GameEvents.updateBlocks(level, pos);
            event.setCanceled(true);
        }
    }

    public static void updateBlocks(Level level, BlockPos pos) {
        level.m_5518_().m_7174_(pos);
        BlockState state = level.m_8055_(pos);
        level.m_7260_(pos, state, state, 3);
        level.m_46672_(pos, state.m_60734_());
    }

    @SubscribeEvent
    public static void loadChunk(ChunkWatchEvent.Watch event) {
        LevelChunk chunk = event.getChunk();
        ChunkPos chunkPos = event.getPos();
        ServerPlayer serverPlayer = event.getPlayer();
        ServerLevel serverLevel = event.getLevel();
        ChunkFacadeMap facadeMapForChunk = CableFacadeSavedData.get(serverLevel).getFacadeMapForChunk(chunkPos);
        if (facadeMapForChunk != null) {
            CFMessages.sendToChunk(new AddFacadedBlocksPacket(chunkPos, facadeMapForChunk.getChunkMap()), chunk);
        }
    }

    @SubscribeEvent
    public static void unloadChunk(ChunkWatchEvent.UnWatch event) {
        ChunkPos chunkPos = event.getPos();
        ServerPlayer serverPlayer = event.getPlayer();
        CFMessages.sendToPlayer(new RemoveFacadedBlocksPacket(chunkPos), serverPlayer);
    }
}

