/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.mixins;

import com.portingdeadmods.cable_facades.events.ClientFacadeManager;
import com.portingdeadmods.cable_facades.utils.FacadeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.extensions.IForgeBlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockState.class})
public abstract class BlockStateMixin
extends BlockBehaviour.BlockStateBase
implements IForgeBlockState {
    @Unique
    private static final ThreadLocal<Boolean> cable_facades$recursionGuard = ThreadLocal.withInitial(() -> false);

    @Shadow
    protected abstract BlockState m_7160_();

    private BlockStateMixin() {
        super(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockState getAppearance(BlockAndTintGetter blockGetter, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        if (cable_facades$recursionGuard.get().booleanValue()) {
            return this.m_60734_().getAppearance(this.m_7160_(), blockGetter, pos, side, queryState, queryPos);
        }
        cable_facades$recursionGuard.set(true);
        try {
            Block camoBlock;
            if (ClientFacadeManager.FACADED_BLOCKS.containsKey(pos) && (camoBlock = ClientFacadeManager.FACADED_BLOCKS.get(pos)) != null) {
                BlockState camoState = camoBlock.m_49966_();
                BlockState blockState = camoState.m_60734_().getAppearance(camoState, blockGetter, pos, side, queryState, queryPos);
                return blockState;
            }
            BlockState blockState = this.m_60734_().getAppearance(this.m_7160_(), blockGetter, pos, side, queryState, queryPos);
            return blockState;
        }
        finally {
            cable_facades$recursionGuard.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLightEmission(BlockGetter blockGetter, BlockPos pos) {
        if (cable_facades$recursionGuard.get().booleanValue()) {
            return this.m_60734_().getLightEmission(this.m_7160_(), blockGetter, pos);
        }
        cable_facades$recursionGuard.set(true);
        try {
            Block camoBlock;
            if (FacadeUtils.hasFacade(blockGetter, pos) && (camoBlock = FacadeUtils.getFacade(blockGetter, pos)) != null) {
                int n = camoBlock.m_49966_().m_60791_();
                return n;
            }
            int n = this.m_60734_().getLightEmission(this.m_7160_(), blockGetter, pos);
            return n;
        }
        finally {
            cable_facades$recursionGuard.set(false);
        }
    }
}

