/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.networking.s2c;

import com.portingdeadmods.cable_facades.events.ClientFacadeManager;
import com.portingdeadmods.cable_facades.networking.s2c.SyncFacadedBlocks;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkEvent;

public record AddFacadedBlocksPacket(ChunkPos chunkPos, Map<BlockPos, Block> facadedBlocks) {
    public AddFacadedBlocksPacket(FriendlyByteBuf buf) {
        this(buf.m_178383_(), SyncFacadedBlocks.getFacades(buf));
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_178341_(this.chunkPos);
        buf.writeInt(this.facadedBlocks.size());
        for (Map.Entry<BlockPos, Block> entry : this.facadedBlocks.entrySet()) {
            buf.m_130064_(entry.getKey());
            buf.m_130085_(BuiltInRegistries.f_256975_.m_7981_((Object)entry.getValue()));
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            if (!ClientFacadeManager.LOADED_BLOCKS.containsKey(this.chunkPos)) {
                ClientFacadeManager.FACADED_BLOCKS.putAll(this.facadedBlocks);
                ClientFacadeManager.LOADED_BLOCKS.put(this.chunkPos, this.facadedBlocks.keySet().stream().toList());
            }
        });
    }
}

