/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.networking.s2c;

import com.portingdeadmods.cable_facades.events.ClientFacadeManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkEvent;

public record SyncFacadedBlocks(Map<BlockPos, Block> facadedBlocks) {
    public SyncFacadedBlocks(FriendlyByteBuf buf) {
        this(SyncFacadedBlocks.getFacades(buf));
    }

    public static Map<BlockPos, Block> getFacades(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashMap<BlockPos, Block> facades = new HashMap<BlockPos, Block>(size);
        for (int i = 0; i < size; ++i) {
            facades.put(buf.m_130135_(), (Block)BuiltInRegistries.f_256975_.m_7745_(buf.m_130281_()));
        }
        return facades;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.facadedBlocks.size());
        for (Map.Entry<BlockPos, Block> entry : this.facadedBlocks.entrySet()) {
            buf.m_130064_(entry.getKey());
            buf.m_130085_(BuiltInRegistries.f_256975_.m_7981_((Object)entry.getValue()));
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ClientFacadeManager.FACADED_BLOCKS = this.facadedBlocks;
        });
    }
}

