/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block;

import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WORKING = BooleanProperty.m_61465_((String)"working");
    public static final IntegerProperty TIER_LEVEL = IntegerProperty.m_61631_((String)"tier_level", (int)0, (int)3);
    public static final EnumProperty<MobFarmType> FARM_TYPE = EnumProperty.m_61587_((String)"farm_type", MobFarmType.class);
    protected static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    public MobFarmBlock(MobFarmType mobFarmType) {
        this(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60999_().m_60978_(5.0f).m_60953_(MobFarmBlock::getLightLevel).m_60918_(SoundType.f_56743_).m_60955_(), mobFarmType);
    }

    public MobFarmBlock(BlockBehaviour.Properties properties, MobFarmType mobFarmType) {
        this(properties, 0, mobFarmType);
    }

    public MobFarmBlock(BlockBehaviour.Properties properties, int tierLevel, MobFarmType mobFarmType) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WORKING, (Comparable)Boolean.FALSE)).m_61124_((Property)TIER_LEVEL, (Comparable)Integer.valueOf(tierLevel))).m_61124_(FARM_TYPE, (Comparable)((Object)mobFarmType)));
    }

    public static int getLightLevel(BlockState blockState) {
        return Boolean.TRUE.equals(blockState.m_61143_((Property)WORKING)) ? 15 : 8;
    }

    public static int getTierLevel(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)TIER_LEVEL);
    }

    public static MobFarmType getFarmType(BlockState blockState) {
        return (MobFarmType)((Object)blockState.m_61143_(FARM_TYPE));
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState, MobFarmType mobFarmType) {
        throw new UnsupportedOperationException("This method must be overridden by a subclass!");
    }

    public void m_6810_(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof MobFarmBlockEntity) {
                MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity;
                mobFarmBlockEntity.dropInventoryContents();
                level.m_46717_(blockPos, (Block)this);
            }
            super.m_6810_(state, level, blockPos, newState, isMoving);
        }
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return this.newBlockEntity(blockPos, blockState, MobFarmBlock.getFarmType(blockState));
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockState) {
        blockState.m_61104_(new Property[]{FACING, WORKING, TIER_LEVEL, FARM_TYPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity blockEntityInstance = (MobFarmBlockEntity)blockEntity;
            if (level instanceof ServerLevel) {
                int tierLevel;
                ServerLevel serverLevel = (ServerLevel)level;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    blockEntityInstance.setOwner((Player)serverPlayer);
                }
                if ((tierLevel = itemStack.m_41784_().m_128451_("TierLevel")) >= 0) {
                    BlockState newBlockState = (BlockState)blockState.m_61124_((Property)TIER_LEVEL, (Comparable)Integer.valueOf(tierLevel));
                    serverLevel.m_7731_(blockPos, newBlockState, 3);
                    blockEntityInstance.setFarmTierLevel(tierLevel);
                    blockEntity.m_6596_();
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof MobFarmBlockEntity)) {
            return InteractionResult.FAIL;
        }
        MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity;
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (!itemStack.m_41619_() && (mobFarmBlockEntity.takeMobCaptureItem(player, interactionHand) || mobFarmBlockEntity.takeEnhancementItem(player, interactionHand) || mobFarmBlockEntity.takeSlotUpgradeItem(player, interactionHand) || mobFarmBlockEntity.takeFilterItem(player, interactionHand))) {
            return InteractionResult.CONSUME;
        }
        if (player.m_6144_() && mobFarmBlockEntity.hasCapturedMob()) {
            mobFarmBlockEntity.giveMobCaptureItem(player, interactionHand);
            return InteractionResult.CONSUME;
        }
        this.openMenu(level, blockPos, player);
        return InteractionResult.CONSUME;
    }

    protected void openMenu(Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity blockEntityInstance = (MobFarmBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5893_((MenuProvider)blockEntityInstance);
            }
        }
    }
}

