/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block.entity;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.config.MobFarmBonusConfig;
import de.markusbordihn.easymobfarm.config.MobFarmConfig;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureDataSupport;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmContainerData;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmSlot;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmSlots;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.experience.ExperienceManager;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import de.markusbordihn.easymobfarm.item.upgrade.EnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.FilterItem;
import de.markusbordihn.easymobfarm.item.upgrade.SlotUpgradeItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SpeedEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.filter.NoFlowersFilterItem;
import de.markusbordihn.easymobfarm.item.upgrade.filter.NoMeatFilterItem;
import de.markusbordihn.easymobfarm.loot.LootManager;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import de.markusbordihn.easymobfarm.tags.ModItemTags;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    public static final String ID = "mob_farm_entity";
    public static final int DEFAULT_FARM_PROCESSING_TIME = 6000;
    public static final int DEFAULT_PROCESSING_TICKS = 20;
    public static final int DEFAULT_RECHECK_TICKS = 200;
    public static final String TIER_LEVEL_TAG = "TierLevel";
    public static final String FARM_TYPE_TAG = "FarmType";
    public static final String CAPTURED_MOB_EXPERIENCE_TAG = "CapturedMobExperience";
    protected static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final int[] RESULT_SLOTS = MobFarmSlots.RESULT_SLOTS.stream().mapToInt(MobFarmSlot::index).toArray();
    private static final Random random = new Random();
    protected final NonNullList<ItemStack> items = NonNullList.m_122780_((int)52, (Object)ItemStack.f_41583_);
    private final ContainerData data = new MobFarmContainerData(this);
    private final int processingDelay;
    private MobFarmType mobFarmType;
    private int farmTierLevel;
    private int numberOfOutputSlots = 6;
    private int farmProgress = 0;
    private int farmProgressionSpeed = 20;
    private int farmStatus = 0;
    private int capturedMobExperience = -1;

    public MobFarmBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        this(blockEntityType, blockPos, blockState, MobFarmBlock.getTierLevel(blockState), MobFarmBlock.getFarmType(blockState));
    }

    public MobFarmBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState, int farmTierLevel, MobFarmType mobFarmType) {
        super(blockEntityType, blockPos, blockState);
        this.setFarmTierLevel(farmTierLevel);
        this.mobFarmType = mobFarmType;
        this.processingDelay = Math.min(Math.max(Math.abs(blockPos.m_123341_() * 31 + blockPos.m_123343_() * 17) % 20 + new Random().nextInt(5), 0), 19);
        this.m_6596_();
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, MobFarmBlockEntity blockEntity) {
        if (!blockEntity.hasCapturedMob() || blockEntity.farmStatus == 401) {
            if (blockEntity.farmStatus != 0) {
                blockEntity.farmStatus = 0;
            }
            return;
        }
        if (blockEntity.farmStatus == 400) {
            if (level.m_46467_() % 200L == 0L && blockEntity.canProcessingResults()) {
                log.debug("Mob farm block entity at {} is no longer full and can process results again", (Object)blockEntity.m_58899_());
                blockEntity.farmStatus = 0;
            } else {
                return;
            }
        }
        if (level.m_46467_() % 20L != (long)blockEntity.processingDelay) {
            return;
        }
        if (blockEntity.farmProgress < 6000) {
            if (blockEntity.farmProgress % 200 == 0) {
                log.debug("Mob farm block entity at {} with farm progress {} / {}", (Object)blockPos, (Object)blockEntity.farmProgress, (Object)6000);
            }
            int farmProgressionSpeed = MobFarmBlockEntity.getEffectiveFarmProgressionSpeed(blockEntity);
            blockEntity.farmProgress = Math.min(blockEntity.farmProgress + farmProgressionSpeed, 6000);
            blockEntity.farmStatus = 200;
            return;
        }
        if (blockEntity.canProcessingResults()) {
            blockEntity.processingResults();
        } else {
            log.warn("Mob farm block entity at {} is full and can't process results", (Object)blockEntity.m_58899_());
            blockEntity.farmStatus = 400;
        }
        blockEntity.farmProgress = 0;
    }

    private static int getEffectiveFarmProgressionSpeed(MobFarmBlockEntity blockEntity) {
        return blockEntity.getFarmProgressionSpeed() + blockEntity.getFarmProgressionSpeedBonus();
    }

    public int getFarmProgressionSpeed() {
        return this.farmProgressionSpeed;
    }

    public int getFarmProgressionSpeedBonus() {
        int farmProgressionSpeedBonus = 0;
        for (EnhancementItem enhancementItem : this.getEnchantmentItems()) {
            if (!(enhancementItem instanceof SpeedEnhancementItem)) continue;
            SpeedEnhancementItem speedEnhancementItem = (SpeedEnhancementItem)enhancementItem;
            farmProgressionSpeedBonus += speedEnhancementItem.getUpgradeSpeed();
        }
        return farmProgressionSpeedBonus;
    }

    public List<EnhancementItem> getEnchantmentItems() {
        ArrayList<EnhancementItem> enchantmentItems = new ArrayList<EnhancementItem>();
        for (MobFarmSlot upgradeSlot : MobFarmSlots.ENHANCEMENT_ITEM_SLOTS) {
            Item item;
            ItemStack itemStack = this.m_8020_(upgradeSlot.index());
            if (itemStack.m_41619_() || !((item = itemStack.m_41720_()) instanceof EnhancementItem)) continue;
            EnhancementItem enhancementItem = (EnhancementItem)item;
            enchantmentItems.add(enhancementItem);
        }
        return enchantmentItems;
    }

    public Set<FilterItem> getFilterItems() {
        HashSet<FilterItem> filterItems = new HashSet<FilterItem>();
        for (MobFarmSlot filterSlot : MobFarmSlots.FILTER_ITEM_SLOTS) {
            Item item;
            ItemStack itemStack = this.m_8020_(filterSlot.index());
            if (itemStack.m_41619_() || !((item = itemStack.m_41720_()) instanceof FilterItem)) continue;
            FilterItem filterItem = (FilterItem)item;
            filterItems.add(filterItem);
        }
        return filterItems;
    }

    public Set<SlotUpgradeItem> getSlotUpgradeItems() {
        HashSet<SlotUpgradeItem> slotUpgradeItems = new HashSet<SlotUpgradeItem>();
        for (MobFarmSlot upgradeSlot : MobFarmSlots.SLOT_UPGRADE_ITEM_SLOTS) {
            Item item;
            ItemStack itemStack = this.m_8020_(upgradeSlot.index());
            if (itemStack.m_41619_() || !((item = itemStack.m_41720_()) instanceof SlotUpgradeItem)) continue;
            SlotUpgradeItem slotUpgradeItem = (SlotUpgradeItem)item;
            slotUpgradeItems.add(slotUpgradeItem);
        }
        return slotUpgradeItems;
    }

    public boolean canProcessingResults() {
        int startSlotIndex;
        for (int slotIndex = startSlotIndex = MobFarmSlots.RESULT_SLOTS.get(0).index(); slotIndex < startSlotIndex + this.numberOfOutputSlots; ++slotIndex) {
            if (!this.m_8020_(slotIndex).m_41619_() && this.m_8020_(slotIndex).m_41613_() >= this.m_8020_(slotIndex).m_41741_()) continue;
            return true;
        }
        return false;
    }

    private boolean processingLuckyDrops(MobCaptureData mobCaptureData, NonNullList<ItemStack> lootDrops) {
        NonNullList<ItemStack> luckyDrop;
        if (this.getFarmType() != MobFarmType.LUCKY_DROP_FARM) {
            return false;
        }
        int luckRoll = random.nextInt(100);
        if (luckRoll > 95) {
            log.debug("Bad lucky drop for {} (tier: {}) block entity at {} with captured mob {}", (Object)this.getFarmType(), (Object)this.getFarmTierLevel(), (Object)this.m_58899_(), mobCaptureData.entityType());
            this.spawnEntity(mobCaptureData.entityType(), this.f_58857_, this.m_58899_().m_7494_());
            this.m_7407_(MobFarmSlot.CAPTURED_MOB.index(), 1);
            this.farmStatus = 0;
            return true;
        }
        log.debug("Lucky drop for {} (tier: {}) block entity at {} with captured mob {}", (Object)this.getFarmType(), (Object)this.getFarmTierLevel(), (Object)this.m_58899_(), mobCaptureData.entityType());
        if (random.nextInt(2) == 0 && !(luckyDrop = LootManager.getLuckyLoot(mobCaptureData, this.m_58899_(), this.f_58857_)).isEmpty()) {
            log.debug("Adding lucky loot drop {} for {} (tier: {}) block entity at {} with captured mob {}", luckyDrop, (Object)this.getFarmType(), (Object)this.getFarmTierLevel(), (Object)this.m_58899_(), mobCaptureData.entityType());
            lootDrops.addAll(luckyDrop);
        }
        return false;
    }

    public void processingResults() {
        MobCaptureData mobCaptureData = this.getMobCaptureData();
        if (mobCaptureData == null) {
            return;
        }
        this.farmStatus = 102;
        NonNullList<ItemStack> lootDrops = LootManager.getEntityLoot(mobCaptureData, this.getEnchantmentItems(), this.f_58857_);
        if (this.processingLuckyDrops(mobCaptureData, lootDrops)) {
            return;
        }
        ItemStack bonusLootDrop = MobFarmBonusConfig.getBonusDrop(this.getFarmType(), this.getFarmTierLevel(), mobCaptureData.entityType());
        if (!bonusLootDrop.m_41619_()) {
            log.debug("Adding bonus loot drop {} for {} (tier: {}) block entity at {} with captured mob {}", (Object)bonusLootDrop, (Object)this.getFarmType(), (Object)this.getFarmTierLevel(), (Object)this.m_58899_(), mobCaptureData.entityType());
            lootDrops.add((Object)bonusLootDrop.m_41777_());
        }
        this.handleLootDrops(lootDrops);
        this.farmStatus = 0;
    }

    private void handleLootDrops(NonNullList<ItemStack> lootDrops) {
        if (lootDrops == null || lootDrops.isEmpty()) {
            return;
        }
        log.debug("Processing loot drops for mob farm block entity at {} with {} loot drops", (Object)this.m_58899_(), lootDrops);
        for (ItemStack lootDrop : lootDrops) {
            if (lootDrop.m_41619_()) continue;
            for (FilterItem filterItem : this.getFilterItems()) {
                if (filterItem instanceof NoMeatFilterItem && lootDrop.m_204117_(ModItemTags.MEAT)) {
                    lootDrop.m_41764_(0);
                }
                if (!(filterItem instanceof NoFlowersFilterItem) || !lootDrop.m_204117_(ModItemTags.FLOWERS)) continue;
                lootDrop.m_41764_(0);
            }
            for (MobFarmSlot filterSlot : MobFarmSlots.FILTER_ITEM_SLOTS) {
                ItemStack filterItem = this.m_8020_(filterSlot.index());
                if (filterItem.m_41619_() || !filterItem.m_150930_(lootDrop.m_41720_())) continue;
                log.debug("Filter slot {} matches loot drop {}", (Object)filterSlot, (Object)lootDrop);
                lootDrop.m_41764_(0);
                break;
            }
            this.storeItemInOutputSlot(lootDrop);
        }
    }

    private void storeItemInOutputSlot(ItemStack itemStack) {
        int startSlotIndex;
        for (int slotIndex = startSlotIndex = MobFarmSlots.RESULT_SLOTS.get(0).index(); slotIndex < startSlotIndex + this.numberOfOutputSlots; ++slotIndex) {
            ItemStack outputSlot = this.m_8020_(slotIndex);
            if (outputSlot.m_41619_()) {
                this.setItemInSlot(slotIndex, itemStack);
                break;
            }
            if (!this.canGrowOutputSlot(outputSlot, itemStack)) continue;
            this.growOutputSlot(outputSlot, itemStack);
            if (itemStack.m_41619_()) break;
        }
    }

    private void setItemInSlot(int slotIndex, ItemStack itemStack) {
        this.m_6836_(slotIndex, itemStack);
    }

    private boolean canGrowOutputSlot(ItemStack outputSlot, ItemStack itemStack) {
        return outputSlot.m_150930_(itemStack.m_41720_()) && outputSlot.m_41613_() < outputSlot.m_41741_();
    }

    private void growOutputSlot(ItemStack outputSlot, ItemStack itemStack) {
        int amountToGrow = Math.min(itemStack.m_41613_(), outputSlot.m_41741_() - outputSlot.m_41613_());
        outputSlot.m_41769_(amountToGrow);
        itemStack.m_41774_(amountToGrow);
    }

    public MobCaptureData getMobCaptureData() {
        return MobCaptureManager.getMobCaptureData(this.getItem(MobFarmSlot.CAPTURED_MOB));
    }

    public boolean hasCapturedMob() {
        return !this.getItem(MobFarmSlot.CAPTURED_MOB).m_41619_();
    }

    public ItemStack takeItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = this.m_8020_(index);
        this.m_6836_(index, ItemStack.f_41583_);
        return itemStack;
    }

    public void giveMobCaptureItem(Player player, InteractionHand hand) {
        ItemStack capturedMob = this.getCapturedMob();
        if (capturedMob.m_41619_()) {
            return;
        }
        this.givePlayerItem(MobFarmSlot.CAPTURED_MOB.index(), player.m_9236_(), player, hand, player.m_20183_());
    }

    public void givePlayerItem(int index, Level level, Player player, InteractionHand hand, BlockPos blockPos) {
        ItemStack itemStack = this.takeItem(index);
        if (itemStack.m_41619_() || itemStack.m_41763_() && itemStack.m_41773_() >= itemStack.m_41776_()) {
            return;
        }
        ItemStack handItemStack = player.m_21120_(hand);
        if (handItemStack.m_41619_()) {
            player.m_21008_(hand, itemStack);
        } else if (!player.m_150109_().m_36054_(itemStack) && level != null) {
            level.m_7967_((Entity)new ItemEntity(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, itemStack));
        }
        this.syncChanges();
    }

    private boolean isInvalidHandItem(ItemStack handItemStack) {
        return handItemStack.m_41619_() || handItemStack.m_41763_() && handItemStack.m_41773_() >= handItemStack.m_41776_();
    }

    public boolean takeMobCaptureItem(Player player, InteractionHand hand) {
        ItemStack handItemStack = player.m_21120_(hand);
        if (this.isInvalidHandItem(handItemStack)) {
            return false;
        }
        if ((MobCaptureDataSupport.isSupported(handItemStack) || handItemStack.m_41720_() instanceof MobCaptureCardItem) && this.getItem(MobFarmSlot.CAPTURED_MOB).m_41619_()) {
            return this.takePlayerItem(MobFarmSlot.CAPTURED_MOB.index(), player, hand);
        }
        return false;
    }

    public boolean takeEnhancementItem(Player player, InteractionHand hand) {
        ItemStack handItemStack = player.m_21120_(hand);
        if (this.isInvalidHandItem(handItemStack)) {
            return false;
        }
        Item handItem = handItemStack.m_41720_();
        if (handItem instanceof EnhancementItem) {
            for (MobFarmSlot upgradeSlot : MobFarmSlots.ENHANCEMENT_ITEM_SLOTS) {
                ItemStack itemStack = this.m_8020_(upgradeSlot.index());
                if (!itemStack.m_41619_()) continue;
                return this.takePlayerItem(upgradeSlot.index(), player, hand);
            }
        }
        return false;
    }

    public boolean takeSlotUpgradeItem(Player player, InteractionHand hand) {
        ItemStack handItemStack = player.m_21120_(hand);
        if (this.isInvalidHandItem(handItemStack)) {
            return false;
        }
        Item handItem = handItemStack.m_41720_();
        if (handItem instanceof SlotUpgradeItem) {
            for (MobFarmSlot upgradeSlot : MobFarmSlots.SLOT_UPGRADE_ITEM_SLOTS) {
                ItemStack itemStack = this.m_8020_(upgradeSlot.index());
                if (!itemStack.m_41619_()) continue;
                return this.takePlayerItem(upgradeSlot.index(), player, hand);
            }
        }
        return false;
    }

    public boolean takeFilterItem(Player player, InteractionHand hand) {
        ItemStack handItemStack = player.m_21120_(hand);
        if (this.isInvalidHandItem(handItemStack)) {
            return false;
        }
        Item handItem = handItemStack.m_41720_();
        if (handItem instanceof FilterItem) {
            for (MobFarmSlot filterSlot : MobFarmSlots.FILTER_ITEM_SLOTS) {
                ItemStack itemStack = this.m_8020_(filterSlot.index());
                if (itemStack.m_150930_(handItemStack.m_41720_())) {
                    return false;
                }
                if (!itemStack.m_41619_()) continue;
                return this.takePlayerItem(filterSlot.index(), player, hand);
            }
        }
        return false;
    }

    public boolean takePlayerItem(int index, Player player, InteractionHand hand) {
        ItemStack handItemStack = player.m_21120_(hand);
        if (handItemStack.m_41619_() || handItemStack.m_41763_() && handItemStack.m_41773_() >= handItemStack.m_41776_()) {
            return false;
        }
        ItemStack itemStack = handItemStack.m_41777_();
        itemStack.m_41764_(1);
        this.m_6836_(index, itemStack);
        if (player.m_7500_()) {
            handItemStack.m_41774_(1);
        }
        this.syncChanges();
        return true;
    }

    public int getNumberOfOutputSlots() {
        return this.numberOfOutputSlots;
    }

    public void setNumberOfOutputSlots(int numberOfOutputSlots) {
        this.numberOfOutputSlots = numberOfOutputSlots;
    }

    public int getFarmProgress() {
        return this.farmProgress;
    }

    public void setFarmProgress(int farmProgress) {
        this.farmProgress = farmProgress;
    }

    public int getFarmStatus() {
        return this.farmStatus;
    }

    public void setFarmStatus(int farmStatus) {
        this.farmStatus = farmStatus;
    }

    public int getFarmTierLevel() {
        return this.farmTierLevel;
    }

    public void setFarmTierLevel(int farmTierLevel) {
        if (this.data.m_6413_(6) == farmTierLevel) {
            return;
        }
        this.farmProgressionSpeed = 20;
        this.farmProgressionSpeed += MobFarmConfig.getFarmTierProgressionUpgradeSpeed(farmTierLevel);
        log.debug("Set mob farm tier level to {}", (Object)farmTierLevel);
        this.farmTierLevel = farmTierLevel;
    }

    public MobFarmType getFarmType() {
        return this.mobFarmType;
    }

    public ItemStack getCapturedMob() {
        return this.getItem(MobFarmSlot.CAPTURED_MOB);
    }

    public int getCapturedMobExperience() {
        return this.capturedMobExperience;
    }

    public ItemStack getItem(MobFarmSlot mobFarmSlot) {
        return (ItemStack)this.items.get(mobFarmSlot.index());
    }

    public void syncChanges() {
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void setOwner(Player player) {
        log.info("Set owner for mob farm block entity to {}", (Object)player);
    }

    public ContainerData getContainerData() {
        return this.data;
    }

    public void dropInventoryContents() {
        if (!this.f_58857_.f_46443_ && !this.items.isEmpty()) {
            for (ItemStack stack : this.items) {
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stack);
            }
        }
    }

    private void spawnEntity(EntityType<?> entityType, Level level, BlockPos position) {
        if (entityType == null || level == null || position == null) {
            return;
        }
        Entity entity = entityType.m_20615_(level);
        if (entity != null) {
            log.debug("Spawn entity {} at position {} for mob farm block entity at {}", (Object)entity, (Object)position, (Object)this.m_58899_());
            entity.m_6034_((double)position.m_123341_() + 0.5, (double)(position.m_123342_() + 1), (double)position.m_123343_() + 0.5);
            level.m_7967_(entity);
        }
    }

    private void setsMobCaptureItem(ItemStack itemStack) {
        log.debug("Sets mob capture item {} in mob farm block entity at {}", (Object)itemStack, (Object)this.m_58899_());
        MobCaptureData mobCaptureData = this.getMobCaptureData();
        EntityType<?> entityType = mobCaptureData != null ? mobCaptureData.entityType() : null;
        LivingEntity livingEntity = entityType != null ? (LivingEntity)entityType.m_20615_(this.f_58857_) : null;
        this.capturedMobExperience = livingEntity != null ? ExperienceManager.getExperienceReward(livingEntity) : 0;
    }

    private void removedMobCaptureItem(ItemStack itemStack) {
        log.debug("Removed mob capture item {} from mob farm block entity at {}", (Object)itemStack, (Object)this.m_58899_());
        this.capturedMobExperience = -1;
    }

    protected Component m_6820_() {
        return TextComponent.getTranslatedTextRaw("container.easy_mob_farm.mob_farm");
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory inventory) {
        return null;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        if (index == MobFarmSlot.CAPTURED_MOB.index() && !itemStack.m_41619_()) {
            this.removedMobCaptureItem(itemStack);
            this.syncChanges();
        }
        return itemStack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack itemStack = ContainerHelper.m_18966_(this.items, (int)index);
        if (index == MobFarmSlot.CAPTURED_MOB.index() && !itemStack.m_41619_()) {
            this.removedMobCaptureItem(itemStack);
        }
        return itemStack;
    }

    public void m_6836_(int index, ItemStack itemStack) {
        this.items.set(index, (Object)itemStack);
        if (itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        if (index == MobFarmSlot.CAPTURED_MOB.index() && !itemStack.m_41619_()) {
            this.setsMobCaptureItem(itemStack.m_41777_());
        }
        this.syncChanges();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public boolean m_6542_(Player player) {
        return player.m_6084_();
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.DOWN || direction == Direction.NORTH || direction == Direction.EAST || direction == Direction.SOUTH || direction == Direction.WEST) {
            return RESULT_SLOTS;
        }
        if (direction == Direction.UP) {
            return new int[0];
        }
        return new int[0];
    }

    public boolean m_7155_(int face, ItemStack itemStack, Direction direction) {
        return direction == Direction.UP;
    }

    public boolean m_7157_(int slot, ItemStack itemStack, Direction direction) {
        if (direction == Direction.UP) {
            return false;
        }
        for (int resultSlot : RESULT_SLOTS) {
            if (slot != resultSlot) continue;
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)compoundTag, this.items);
        if (compoundTag.m_128441_(TIER_LEVEL_TAG)) {
            this.setFarmTierLevel(compoundTag.m_128451_(TIER_LEVEL_TAG));
        }
        if (compoundTag.m_128441_(FARM_TYPE_TAG)) {
            this.mobFarmType = MobFarmType.valueOf(compoundTag.m_128461_(FARM_TYPE_TAG));
        }
        if (compoundTag.m_128441_(CAPTURED_MOB_EXPERIENCE_TAG) && compoundTag.m_128451_(CAPTURED_MOB_EXPERIENCE_TAG) >= 0) {
            this.capturedMobExperience = compoundTag.m_128451_(CAPTURED_MOB_EXPERIENCE_TAG);
        }
    }

    public void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, this.items);
        compoundTag.m_128405_(TIER_LEVEL_TAG, this.farmTierLevel);
        compoundTag.m_128359_(FARM_TYPE_TAG, this.mobFarmType.name());
        if (this.capturedMobExperience >= 0) {
            compoundTag.m_128405_(CAPTURED_MOB_EXPERIENCE_TAG, this.capturedMobExperience);
        }
    }
}

