/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.client.renderer.manager.EntityScalingManager;
import de.markusbordihn.easymobfarm.client.renderer.manager.RendererManager;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.block.state.properties.Property;

public class MobFarmBlockEntityRenderer<T extends MobFarmBlockEntity>
implements BlockEntityRenderer<T> {
    public MobFarmBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (!((MobFarmBlockEntity)((Object)blockEntity)).hasCapturedMob()) {
            RendererManager.removeEntity(blockEntity);
            return;
        }
        Entity entity = RendererManager.getOrCreateEntity(blockEntity);
        if (entity == null) {
            return;
        }
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer entityRenderer = entityRenderDispatcher.m_114382_(entity);
        entity.f_19797_ = (int)blockEntity.m_58904_().m_46467_();
        MobFarmType mobFarmType = ((MobFarmBlockEntity)((Object)blockEntity)).getFarmType();
        poseStack.m_85836_();
        if (mobFarmType != null) {
            if (mobFarmType == MobFarmType.LUCKY_DROP_FARM) {
                poseStack.m_85837_(0.5, 0.19, 0.5);
            } else {
                poseStack.m_85837_(0.5, 0.08, 0.5);
            }
        } else {
            poseStack.m_85837_(0.5, 0.08, 0.5);
        }
        float entityScaling = EntityScalingManager.getBlockScale(entity);
        if (mobFarmType != null && mobFarmType == MobFarmType.LUCKY_DROP_FARM) {
            entityScaling *= 0.75f;
        }
        poseStack.m_85841_(entityScaling, entityScaling, entityScaling);
        float rotationDegrees = switch ((Direction)blockEntity.m_58900_().m_61143_((Property)MobFarmBlock.FACING)) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> -90.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        };
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationDegrees));
        if (entity instanceof AbstractSchoolingFish) {
            poseStack.m_85837_(-0.1, 0.5, 0.1);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(2.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(15.0f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
        } else if (entity instanceof Bee) {
            poseStack.m_85837_(0.0, 0.5, 0.0);
        } else if (entity instanceof Squid) {
            poseStack.m_85837_(0.0, 1.3, 0.0);
        } else if (entity instanceof Phantom) {
            poseStack.m_85837_(0.0, 0.5, 0.0);
        }
        entityRenderer.m_7392_(entity, 0.0f, 0.0f, poseStack, buffer, combinedLight);
        poseStack.m_85849_();
    }
}

