/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.manager;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;

public class EntityScalingManager {
    private static final float MAX_BLOCK_SCALE = 0.85f;
    private static final float MAX_UI_WIDTH_PIXELS = 47.0f;
    private static final float MAX_UI_HEIGHT_PIXELS = 71.0f;
    private static final float DEFAULT_SCALE_BLOCK = 0.4f;
    private static final float DEFAULT_SCALE_UI = 0.4f;
    private static final Map<Class<? extends Entity>, Float> blockScaleCache = new HashMap<Class<? extends Entity>, Float>();
    private static final Map<Class<? extends Entity>, Integer> uiScaleCache = new HashMap<Class<? extends Entity>, Integer>();

    private EntityScalingManager() {
    }

    public static float getBlockScale(Entity entity) {
        return blockScaleCache.computeIfAbsent(entity.getClass(), cls -> {
            float entityHeight;
            float entityWidth;
            if (entity.m_20191_().m_82362_() > 0.0 && entity.m_20191_().m_82376_() > 0.0) {
                entityWidth = (float)entity.m_20191_().m_82362_();
                entityHeight = (float)entity.m_20191_().m_82376_();
            } else {
                entityWidth = entity.m_6972_((Pose)entity.m_20089_()).f_20377_;
                entityHeight = entity.m_6972_((Pose)entity.m_20089_()).f_20378_;
            }
            if (entityWidth == 0.0f || entityHeight == 0.0f) {
                return Float.valueOf(0.4f);
            }
            if (entityWidth < 0.85f && entityHeight < 0.85f || entityWidth * 0.4f < 0.85f && entityHeight * 0.4f < 0.85f) {
                return Float.valueOf(0.4f);
            }
            float scaleFactor = Math.max(entityWidth, entityHeight) / 0.85f;
            return Float.valueOf(scaleFactor > 1.0f ? 0.85f / scaleFactor : 0.85f);
        }).floatValue();
    }

    public static int getUIScale(Entity entity) {
        return uiScaleCache.computeIfAbsent(entity.getClass(), cls -> {
            float entityHeight;
            float entityWidth;
            if (entity.m_20191_().m_82362_() > 0.0 && entity.m_20191_().m_82376_() > 0.0) {
                entityWidth = (float)entity.m_20191_().m_82362_();
                entityHeight = (float)entity.m_20191_().m_82376_();
            } else {
                entityWidth = entity.m_6972_((Pose)entity.m_20089_()).f_20377_;
                entityHeight = entity.m_6972_((Pose)entity.m_20089_()).f_20378_;
            }
            if (entityWidth == 0.0f || entityHeight == 0.0f) {
                return Math.round(3.6000001f);
            }
            if (entityWidth < 47.0f && entityHeight < 71.0f || entityWidth * 0.4f < 47.0f && entityHeight * 0.4f < 71.0f) {
                return (int)(0.4f * Math.min(47.0f, 71.0f));
            }
            float scaleFactor = Math.min(47.0f / (entityWidth * 16.0f), 71.0f / (entityHeight * 16.0f));
            return Math.round(scaleFactor * 9.0f);
        });
    }
}

