/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.Config;
import java.io.File;
import java.util.Properties;
import java.util.Set;

public class MobCatcherConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "mob_catcher.cfg";
    public static final String CONFIG_FILE_HEADER = " Mob Catcher Configuration\n\n This configuration file allows you to define the general settings for the Mob Catcher.\n\n Allow and Deny list\n -------------------\n If you want to allow or deny specific mobs, you can use the allow and deny list.\n Keep in mind that if you add a mob to the allow list, all other mobs will be denied by default.\n Additionally mobs on the allow list will be catchable even if their size is bigger than the maximum size.\n\n Each Mob Catcher has it own allow and deny list, so you can define different settings for each Mob Catcher.\n\n  Example for allow only specific mobs:\n    EnduringCaptureNet:AllowList=minecraft:cow,minecraft:sheep,minecraft:chicken\n\n  Example for deny specific mobs:\n    VoidBindingChain:DenyList=minecraft:endermite,minecraft:ender_dragon,minecraft:wither\n\n\n";
    public static int ENDURING_CAPTURE_NET_MAX_DURABILITY = 64;
    public static float ENDURING_CAPTURE_NET_REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE = 0.5f;
    public static float ENDURING_CAPTURE_NET_MAX_ENTITY_HEIGHT_TO_CAPTURE = 1.4f;
    public static float ENDURING_CAPTURE_NET_MAX_ENTITY_WIDTH_TO_CAPTURE = 0.9f;
    public static Set<String> ENDURING_CAPTURE_NET_ALLOW_LIST = Set.of();
    public static Set<String> ENDURING_CAPTURE_NET_DENY_LIST = Set.of();
    public static int IRONBOUND_CONTAINMENT_CAGE_MAX_DURABILITY = 32;
    public static float IRONBOUND_CONTAINMENT_CAGE_REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE = 0.25f;
    public static float IRONBOUND_CONTAINMENT_CAGE_MAX_ENTITY_HEIGHT_TO_CAPTURE = 2.0f;
    public static float IRONBOUND_CONTAINMENT_CAGE_MAX_ENTITY_WIDTH_TO_CAPTURE = 1.5f;
    public static Set<String> IRONBOUND_CONTAINMENT_CAGE_ALLOW_LIST = Set.of();
    public static Set<String> IRONBOUND_CONTAINMENT_CAGE_DENY_LIST = Set.of();
    public static int MYSTIC_BINDING_CRYSTAL_MAX_DURABILITY = 32;
    public static float MYSTIC_BINDING_CRYSTAL_REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE = 0.25f;
    public static float MYSTIC_BINDING_CRYSTAL_MAX_ENTITY_HEIGHT_TO_CAPTURE = 4.0f;
    public static float MYSTIC_BINDING_CRYSTAL_MAX_ENTITY_WIDTH_TO_CAPTURE = 3.0f;
    public static Set<String> MYSTIC_BINDING_CRYSTAL_ALLOW_LIST = Set.of();
    public static Set<String> MYSTIC_BINDING_CRYSTAL_DENY_LIST = Set.of();
    public static int VOID_BINDING_CHAIN_MAX_DURABILITY = 16;
    public static float VOID_BINDING_CHAIN_REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE = 0.2f;
    public static float VOID_BINDING_CHAIN_MAX_ENTITY_HEIGHT_TO_CAPTURE = 6.0f;
    public static float VOID_BINDING_CHAIN_MAX_ENTITY_WIDTH_TO_CAPTURE = 4.0f;
    public static Set<String> VOID_BINDING_CHAIN_ALLOW_LIST = Set.of();
    public static Set<String> VOID_BINDING_CHAIN_DENY_LIST = Set.of();

    public static void registerConfig() {
        MobCatcherConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MobCatcherConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = MobCatcherConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MobCatcherConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        ENDURING_CAPTURE_NET_MAX_DURABILITY = MobCatcherConfig.parseConfigValue(properties, "EnduringCaptureNet:MaxDurability", ENDURING_CAPTURE_NET_MAX_DURABILITY);
        ENDURING_CAPTURE_NET_REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE = MobCatcherConfig.parseConfigValue(properties, "EnduringCaptureNet:RequiredHealthPercentageToCapture", ENDURING_CAPTURE_NET_REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE);
        ENDURING_CAPTURE_NET_MAX_ENTITY_HEIGHT_TO_CAPTURE = MobCatcherConfig.parseConfigValue(properties, "EnduringCaptureNet:MaxEntityHeightToCapture", ENDURING_CAPTURE_NET_MAX_ENTITY_HEIGHT_TO_CAPTURE);
        ENDURING_CAPTURE_NET_MAX_ENTITY_WIDTH_TO_CAPTURE = MobCatcherConfig.parseConfigValue(properties, "EnduringCaptureNet:MaxEntityWidthToCapture", ENDURING_CAPTURE_NET_MAX_ENTITY_WIDTH_TO_CAPTURE);
        ENDURING_CAPTURE_NET_ALLOW_LIST = MobCatcherConfig.parseConfigValue(properties, "EnduringCaptureNet:AllowList", ENDURING_CAPTURE_NET_ALLOW_LIST);
        ENDURING_CAPTURE_NET_DENY_LIST = MobCatcherConfig.parseConfigValue(properties, "EnduringCaptureNet:DenyList", ENDURING_CAPTURE_NET_DENY_LIST);
        IRONBOUND_CONTAINMENT_CAGE_MAX_DURABILITY = MobCatcherConfig.parseConfigValue(properties, "IronboundContainmentCage:MaxDurability", IRONBOUND_CONTAINMENT_CAGE_MAX_DURABILITY);
        IRONBOUND_CONTAINMENT_CAGE_REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE = MobCatcherConfig.parseConfigValue(properties, "IronboundContainmentCage:RequiredHealthPercentageToCapture", IRONBOUND_CONTAINMENT_CAGE_REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE);
        IRONBOUND_CONTAINMENT_CAGE_MAX_ENTITY_HEIGHT_TO_CAPTURE = MobCatcherConfig.parseConfigValue(properties, "IronboundContainmentCage:MaxEntityHeightToCapture", IRONBOUND_CONTAINMENT_CAGE_MAX_ENTITY_HEIGHT_TO_CAPTURE);
        IRONBOUND_CONTAINMENT_CAGE_MAX_ENTITY_WIDTH_TO_CAPTURE = MobCatcherConfig.parseConfigValue(properties, "IronboundContainmentCage:MaxEntityWidthToCapture", IRONBOUND_CONTAINMENT_CAGE_MAX_ENTITY_WIDTH_TO_CAPTURE);
        IRONBOUND_CONTAINMENT_CAGE_ALLOW_LIST = MobCatcherConfig.parseConfigValue(properties, "IronboundContainmentCage:AllowList", IRONBOUND_CONTAINMENT_CAGE_ALLOW_LIST);
        IRONBOUND_CONTAINMENT_CAGE_DENY_LIST = MobCatcherConfig.parseConfigValue(properties, "IronboundContainmentCage:DenyList", IRONBOUND_CONTAINMENT_CAGE_DENY_LIST);
        MYSTIC_BINDING_CRYSTAL_MAX_DURABILITY = MobCatcherConfig.parseConfigValue(properties, "MysticBindingCrystal:MaxDurability", MYSTIC_BINDING_CRYSTAL_MAX_DURABILITY);
        MYSTIC_BINDING_CRYSTAL_REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE = MobCatcherConfig.parseConfigValue(properties, "MysticBindingCrystal:RequiredHealthPercentageToCapture", MYSTIC_BINDING_CRYSTAL_REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE);
        MYSTIC_BINDING_CRYSTAL_MAX_ENTITY_HEIGHT_TO_CAPTURE = MobCatcherConfig.parseConfigValue(properties, "MysticBindingCrystal:MaxEntityHeightToCapture", MYSTIC_BINDING_CRYSTAL_MAX_ENTITY_HEIGHT_TO_CAPTURE);
        MYSTIC_BINDING_CRYSTAL_MAX_ENTITY_WIDTH_TO_CAPTURE = MobCatcherConfig.parseConfigValue(properties, "MysticBindingCrystal:MaxEntityWidthToCapture", MYSTIC_BINDING_CRYSTAL_MAX_ENTITY_WIDTH_TO_CAPTURE);
        MYSTIC_BINDING_CRYSTAL_ALLOW_LIST = MobCatcherConfig.parseConfigValue(properties, "MysticBindingCrystal:AllowList", MYSTIC_BINDING_CRYSTAL_ALLOW_LIST);
        MYSTIC_BINDING_CRYSTAL_DENY_LIST = MobCatcherConfig.parseConfigValue(properties, "MysticBindingCrystal:DenyList", MYSTIC_BINDING_CRYSTAL_DENY_LIST);
        VOID_BINDING_CHAIN_MAX_DURABILITY = MobCatcherConfig.parseConfigValue(properties, "VoidBindingChain:MaxDurability", VOID_BINDING_CHAIN_MAX_DURABILITY);
        VOID_BINDING_CHAIN_REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE = MobCatcherConfig.parseConfigValue(properties, "VoidBindingChain:RequiredHealthPercentageToCapture", VOID_BINDING_CHAIN_REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE);
        VOID_BINDING_CHAIN_MAX_ENTITY_HEIGHT_TO_CAPTURE = MobCatcherConfig.parseConfigValue(properties, "VoidBindingChain:MaxEntityHeightToCapture", VOID_BINDING_CHAIN_MAX_ENTITY_HEIGHT_TO_CAPTURE);
        VOID_BINDING_CHAIN_MAX_ENTITY_WIDTH_TO_CAPTURE = MobCatcherConfig.parseConfigValue(properties, "VoidBindingChain:MaxEntityWidthToCapture", VOID_BINDING_CHAIN_MAX_ENTITY_WIDTH_TO_CAPTURE);
        VOID_BINDING_CHAIN_ALLOW_LIST = MobCatcherConfig.parseConfigValue(properties, "VoidBindingChain:AllowList", VOID_BINDING_CHAIN_ALLOW_LIST);
        VOID_BINDING_CHAIN_DENY_LIST = MobCatcherConfig.parseConfigValue(properties, "VoidBindingChain:DenyList", VOID_BINDING_CHAIN_DENY_LIST);
        MobCatcherConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

