/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.Config;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MobFarmBonusConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "mob_farm_bonus.cfg";
    public static final String CONFIG_FILE_HEADER = " Mob Farm Bonus Configuration\n\n This configuration file allows you to define the bonus drops for the Mob Farms.\n\nThe format is as follows:\n- <mob_farm_name>::<tier_level>::<entity_type> = <item_name>::<amount>::<chance 1 of x>\n\nExample:\n- bee_hive_farm::0::minecraft:bee = minecraft:honeycomb::1::20\n- bee_hive_farm::1::minecraft:bee = minecraft:honeycomb::1::15\n- bee_hive_farm::2::minecraft:bee = minecraft:honeycomb::1::10\n- bee_hive_farm::3::minecraft:bee = minecraft:honeycomb::1::5\n\nTo disable a bonus drop for a default definition, set the amount to 0.\n\n";
    private static final Random random = new Random();
    private static final HashMap<String, HashMap<Integer, ItemStack>> mobFarmBonusMap = new HashMap();
    private static final HashMap<String, HashMap<Integer, ItemStack>> defaultMobFarmBonusMap = new HashMap();

    public static void registerConfig() {
        MobFarmBonusConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MobFarmBonusConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = MobFarmBonusConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MobFarmBonusConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        defaultMobFarmBonusMap.forEach((mobFarmName, bonusMap) -> {
            if (!properties.containsKey(mobFarmName)) {
                bonusMap.forEach((chance, itemStack) -> {
                    String itemName = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).toString();
                    String value = itemName + "::" + itemStack.m_41613_() + "::" + chance;
                    properties.setProperty((String)mobFarmName, value);
                });
            }
        });
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String[] keyParts = MobFarmBonusConfig.parseKey((String)key);
            if (keyParts == null) {
                return;
            }
            String mobFarmName = keyParts[0];
            int tierLevel = Integer.parseInt(keyParts[1]);
            String entityType = keyParts[2];
            String[] valueParts = MobFarmBonusConfig.parseValue((String)value);
            if (valueParts == null || valueParts[0].isEmpty()) {
                return;
            }
            String itemName = valueParts[0];
            int amount = Integer.parseInt(valueParts[1]);
            int chance = Integer.parseInt(valueParts[2]);
            if (amount <= 0) {
                log.error("Invalid amount in config file: {}", value);
                return;
            }
            BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(itemName)).ifPresent(item -> {
                ItemStack itemStack = new ItemStack((ItemLike)item, amount);
                if (itemStack.m_41619_()) {
                    log.error("Invalid item in config file ({}): {}", key, value);
                    return;
                }
                mobFarmBonusMap.computeIfAbsent(mobFarmName + "::" + tierLevel + "::" + entityType, k -> new HashMap()).put(chance, itemStack);
            });
        }));
        MobFarmBonusConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static ItemStack getBonusDropEntry(MobFarmType mobFarmType, int tierLevel, EntityType<?> entityType) {
        return MobFarmBonusConfig.getBonusDropEntry(mobFarmType.getId(), tierLevel, String.valueOf(BuiltInRegistries.f_256780_.m_7981_(entityType)));
    }

    public static ItemStack getBonusDropEntry(String mobFarmName, int tierLevel, String entityType) {
        if (!MobFarmBonusConfig.hasBonusDrop(mobFarmName, tierLevel, entityType)) {
            return ItemStack.f_41583_;
        }
        return mobFarmBonusMap.get(mobFarmName + "::" + tierLevel + "::" + entityType).entrySet().stream().map(Map.Entry::getValue).findFirst().orElse(ItemStack.f_41583_);
    }

    public static ItemStack getBonusDrop(MobFarmType mobFarmType, int tierLevel, EntityType<?> entityType) {
        return MobFarmBonusConfig.getBonusDrop(mobFarmType.getId(), tierLevel, String.valueOf(BuiltInRegistries.f_256780_.m_7981_(entityType)));
    }

    public static ItemStack getBonusDrop(String mobFarmName, int tierLevel, String entityType) {
        if (!MobFarmBonusConfig.hasBonusDrop(mobFarmName, tierLevel, entityType)) {
            return ItemStack.f_41583_;
        }
        return mobFarmBonusMap.get(mobFarmName + "::" + tierLevel + "::" + entityType).entrySet().stream().filter(entry -> random.nextInt((Integer)entry.getKey()) == 0).map(Map.Entry::getValue).findFirst().orElse(ItemStack.f_41583_);
    }

    public static boolean hasBonusDrop(String mobFarmName, int tierLevel, EntityType<?> entityType) {
        return MobFarmBonusConfig.hasBonusDrop(mobFarmName, tierLevel, String.valueOf(BuiltInRegistries.f_256780_.m_7981_(entityType)));
    }

    public static boolean hasBonusDrop(String mobFarmName, int tierLevel, String entityType) {
        return mobFarmBonusMap.containsKey(mobFarmName + "::" + tierLevel + "::" + entityType);
    }

    private static String[] parseKey(String key) {
        String[] keyParts = key.split("::");
        if (keyParts.length != 3) {
            log.error("Invalid key format in config file: {}", (Object)key);
            return null;
        }
        return keyParts;
    }

    private static String[] parseValue(String value) {
        String[] valueParts = value.split("::");
        if (valueParts.length != 3) {
            log.error("Invalid value format in config file: {}", (Object)value);
            return null;
        }
        return valueParts;
    }

    static {
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::0::minecraft:cow", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42454_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::1::minecraft:cow", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42454_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::2::minecraft:cow", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42454_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::3::minecraft:cow", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42454_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::0::minecraft:sheep", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_41870_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::1::minecraft:sheep", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_41870_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::2::minecraft:sheep", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_41870_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::3::minecraft:sheep", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_41870_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::0::minecraft:chicken", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42521_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::1::minecraft:chicken", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42521_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::2::minecraft:chicken", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42521_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.ANIMAL_PLAINS_FARM.getId() + "::3::minecraft:chicken", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42521_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.BEE_HIVE_FARM.getId() + "::0::minecraft:bee", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42784_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.BEE_HIVE_FARM.getId() + "::1::minecraft:bee", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42784_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.BEE_HIVE_FARM.getId() + "::2::minecraft:bee", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42784_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.BEE_HIVE_FARM.getId() + "::3::minecraft:bee", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42784_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::0::minecraft:husk", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_41830_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::1::minecraft:husk", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_41830_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::2::minecraft:husk", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_41830_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::3::minecraft:husk", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_41830_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::0::minecraft:rabbit", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42649_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::1::minecraft:rabbit", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42649_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::2::minecraft:rabbit", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42649_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.DESERT_FARM.getId() + "::3::minecraft:rabbit", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42649_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.IRON_GOLEM_FARM.getId() + "::0::minecraft:iron_golem", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42416_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.IRON_GOLEM_FARM.getId() + "::1::minecraft:iron_golem", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42416_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.IRON_GOLEM_FARM.getId() + "::2::minecraft:iron_golem", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42416_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.IRON_GOLEM_FARM.getId() + "::3::minecraft:iron_golem", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42416_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::0::minecraft:parrot", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42402_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::1::minecraft:parrot", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42402_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::2::minecraft:parrot", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42402_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::3::minecraft:parrot", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42402_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::0::minecraft:panda", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_41911_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::1::minecraft:panda", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_41911_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::2::minecraft:panda", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_41911_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.JUNGLE_FARM.getId() + "::3::minecraft:panda", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_41911_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.MONSTER_PLAINS_CAVE_FARM.getId() + "::0::minecraft:zombie", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42583_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.MONSTER_PLAINS_CAVE_FARM.getId() + "::1::minecraft:zombie", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42583_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.MONSTER_PLAINS_CAVE_FARM.getId() + "::2::minecraft:zombie", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42583_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.MONSTER_PLAINS_CAVE_FARM.getId() + "::3::minecraft:zombie", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42583_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::0::minecraft:blaze", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42585_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::1::minecraft:blaze", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42585_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::2::minecraft:blaze", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42585_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::3::minecraft:blaze", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42585_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::0::minecraft:magma_cube", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42542_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::1::minecraft:magma_cube", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42542_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::2::minecraft:magma_cube", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42542_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.NETHER_FORTRESS_FARM.getId() + "::3::minecraft:magma_cube", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42542_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::0::minecraft:cod", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42526_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::1::minecraft:cod", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42526_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::2::minecraft:cod", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42526_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::3::minecraft:cod", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42526_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::0::minecraft:squid", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42532_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::1::minecraft:squid", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42532_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::2::minecraft:squid", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42532_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.OCEAN_FARM.getId() + "::3::minecraft:squid", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42532_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::0::minecraft:frog", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::1::minecraft:frog", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::2::minecraft:frog", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::3::minecraft:frog", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::0::minecraft:slime", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::1::minecraft:slime", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::2::minecraft:slime", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::3::minecraft:slime", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42518_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::0::minecraft:witch", new HashMap<Integer, ItemStack>(Map.of(20, new ItemStack((ItemLike)Items.f_42451_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::1::minecraft:witch", new HashMap<Integer, ItemStack>(Map.of(15, new ItemStack((ItemLike)Items.f_42451_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::2::minecraft:witch", new HashMap<Integer, ItemStack>(Map.of(10, new ItemStack((ItemLike)Items.f_42451_, 1))));
        defaultMobFarmBonusMap.put(MobFarmType.SWAMP_FARM.getId() + "::3::minecraft:witch", new HashMap<Integer, ItemStack>(Map.of(5, new ItemStack((ItemLike)Items.f_42451_, 1))));
    }
}

