/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.config;

import de.markusbordihn.easymobfarm.config.Config;
import java.io.File;
import java.util.Properties;

public class MobFarmConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "mob_farm.cfg";
    public static final String CONFIG_FILE_HEADER = " Mob Farm Configuration\n\n This configuration file allows you to define the general settings for the Mob Farms.\n\n";
    public static int tier0progressionUpgradeSpeed = 0;
    public static int tier1progressionUpgradeSpeed = 3;
    public static int tier2progressionUpgradeSpeed = 6;
    public static int tier3progressionUpgradeSpeed = 9;
    public static int experienceDropChance = 5;
    public static int speedEnhancementUpgradeSpeed = 6;

    public static void registerConfig() {
        MobFarmConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        MobFarmConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = MobFarmConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = MobFarmConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        tier0progressionUpgradeSpeed = MobFarmConfig.parseConfigValue(properties, "tier0progressionUpgradeSpeed", tier0progressionUpgradeSpeed);
        tier1progressionUpgradeSpeed = MobFarmConfig.parseConfigValue(properties, "tier1progressionUpgradeSpeed", tier1progressionUpgradeSpeed);
        tier2progressionUpgradeSpeed = MobFarmConfig.parseConfigValue(properties, "tier2progressionUpgradeSpeed", tier2progressionUpgradeSpeed);
        tier3progressionUpgradeSpeed = MobFarmConfig.parseConfigValue(properties, "tier3progressionUpgradeSpeed", tier3progressionUpgradeSpeed);
        experienceDropChance = MobFarmConfig.parseConfigValue(properties, "experienceDropChance", experienceDropChance);
        speedEnhancementUpgradeSpeed = MobFarmConfig.parseConfigValue(properties, "speedEnhancementUpgradeSpeed", speedEnhancementUpgradeSpeed);
        MobFarmConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }

    public static int getFarmTierProgressionUpgradeSpeed(int tierLevel) {
        return switch (tierLevel) {
            case 0 -> tier0progressionUpgradeSpeed;
            case 1 -> tier1progressionUpgradeSpeed;
            case 2 -> tier2progressionUpgradeSpeed;
            case 3 -> tier3progressionUpgradeSpeed;
            default -> 0;
        };
    }
}

