/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class MobEntityData {
    public static final String DATA_TAG = "Data";
    protected static final String HEALTH_TAG = "Health";
    protected static final Set<String> SAFE_TO_REMOVE_BASE_TAGS = Set.of("Air", "Dead", "DeathTime", "FallDistance", "FallFlying", "Fire", "HurtByTimestamp", "HurtTime", "InWaterTime", "Motion", "OnGround", "PortalCooldown", "Pos", "Rotation");
    protected static final Set<String> UNSAFE_TO_REMOVE_BASE_TAGS = Set.of("UUID", "Attributes");
    protected static final Set<String> SAFE_TO_REMOVE_MOB_CAPTURE_CARD_TAGS = Set.of("AbsorptionAmount", "ActiveEffects", "AngerTime", "Brain", "CanBreakDoors", "CanPickUpLoot", "CanUpdate", "CurativeItems", "DrownedConversionTime", "Health", "Invulnerable", "LeftHanded", "PersistenceRequired", "TimeInOverworld");

    private MobEntityData() {
    }

    public static CompoundTag getMobEntityData(EntityType<?> entityType) {
        return new CompoundTag();
    }

    public static CompoundTag getMobEntityData(LivingEntity livingEntity) {
        CompoundTag compoundTag = new CompoundTag();
        livingEntity.m_20240_(compoundTag);
        if (livingEntity.m_21224_()) {
            compoundTag.m_128350_(HEALTH_TAG, livingEntity.m_21233_());
        }
        compoundTag = MobEntityData.removeSafeToRemoveBaseTags(compoundTag);
        if (!livingEntity.m_8077_()) {
            compoundTag = MobEntityData.removeUnsafeToRemoveBaseTags(compoundTag);
        }
        return compoundTag;
    }

    public static CompoundTag getMobEntityData(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return new CompoundTag();
        }
        if (compoundTag.m_128441_(DATA_TAG)) {
            compoundTag = compoundTag.m_128469_(DATA_TAG);
        }
        return MobEntityData.removeSafeToRemoveBaseTags(compoundTag);
    }

    private static CompoundTag removeSafeToRemoveBaseTags(CompoundTag compoundTag) {
        CompoundTag cleanedCompoundTag = new CompoundTag();
        for (String key : compoundTag.m_128431_()) {
            if (SAFE_TO_REMOVE_BASE_TAGS.contains(key)) continue;
            cleanedCompoundTag.m_128365_(key, compoundTag.m_128423_(key));
        }
        return cleanedCompoundTag;
    }

    private static CompoundTag removeUnsafeToRemoveBaseTags(CompoundTag compoundTag) {
        CompoundTag cleanedCompoundTag = new CompoundTag();
        for (String key : compoundTag.m_128431_()) {
            if (UNSAFE_TO_REMOVE_BASE_TAGS.contains(key)) continue;
            cleanedCompoundTag.m_128365_(key, compoundTag.m_128423_(key));
        }
        return cleanedCompoundTag;
    }

    public static CompoundTag removeSafeToRemoveMobCaptureCardTags(CompoundTag compoundTag) {
        CompoundTag cleanedCompoundTag = new CompoundTag();
        for (String key : compoundTag.m_128431_()) {
            if (SAFE_TO_REMOVE_MOB_CAPTURE_CARD_TAGS.contains(key)) continue;
            if (key.equals("Inventory")) {
                if (compoundTag.m_128423_(key) == null || compoundTag.m_128437_(key, 10).isEmpty()) continue;
                cleanedCompoundTag.m_128365_(key, compoundTag.m_128423_(key));
                continue;
            }
            cleanedCompoundTag.m_128365_(key, compoundTag.m_128423_(key));
        }
        return cleanedCompoundTag;
    }
}

