/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureDataSupport;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class MobEntityTypeData {
    public static final String TYPE_TAG = "Type";
    public static final String ENTITY_TYPE_TAG = "EntityTag";
    public static final String ID_TAG = "id";

    private MobEntityTypeData() {
    }

    public static String getEntityTypeName(LivingEntity livingEntity) {
        return MobEntityTypeData.getEntityTypeName(livingEntity.m_6095_());
    }

    public static String getEntityTypeName(EntityType<?> entityType) {
        return BuiltInRegistries.f_256780_.m_7981_(entityType).toString();
    }

    public static String getEntityTypeName(ItemStack itemStack, CompoundTag compoundTag) {
        String entityTypeName;
        if (itemStack == null || itemStack.m_41619_()) {
            return MobEntityTypeData.getEntityTypeName(compoundTag);
        }
        if (MobCaptureDataSupport.isSupported(itemStack) && (entityTypeName = MobCaptureDataSupport.getEntityTypeName(itemStack)) != null) {
            return entityTypeName;
        }
        return MobEntityTypeData.getEntityTypeName(compoundTag);
    }

    public static String getEntityTypeName(CompoundTag compoundTag) {
        CompoundTag entityTypeTag;
        if (compoundTag == null) {
            return null;
        }
        if (compoundTag.m_128441_(TYPE_TAG)) {
            return compoundTag.m_128461_(TYPE_TAG);
        }
        if (compoundTag.m_128425_(ENTITY_TYPE_TAG, 10) && (entityTypeTag = compoundTag.m_128469_(ENTITY_TYPE_TAG)).m_128425_(ID_TAG, 8)) {
            return entityTypeTag.m_128461_(ID_TAG);
        }
        return null;
    }

    public static EntityType<?> getEntityType(ItemStack itemStack, CompoundTag compoundTag) {
        EntityType<?> entityType;
        if (itemStack == null || itemStack.m_41619_()) {
            return MobEntityTypeData.getEntityType(compoundTag);
        }
        if (MobCaptureDataSupport.isSupported(itemStack) && (entityType = MobCaptureDataSupport.getEntityType(itemStack)) != null) {
            return entityType;
        }
        return MobEntityTypeData.getEntityType(compoundTag);
    }

    public static EntityType<?> getEntityType(EntityType<?> entityType) {
        return entityType;
    }

    public static EntityType<?> getEntityType(LivingEntity livingEntity) {
        return livingEntity.m_6095_();
    }

    public static EntityType<?> getEntityType(CompoundTag compoundTag) {
        String entityTypeName = MobEntityTypeData.getEntityTypeName(compoundTag);
        if (entityTypeName != null) {
            return EntityType.m_20632_((String)entityTypeName).orElse(null);
        }
        return null;
    }
}

