/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.gametest;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.gametest.GameTestHelpers;
import de.markusbordihn.easymobfarm.item.MobFarmBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class MobFarmBlockItemTestHelper {
    private MobFarmBlockItemTestHelper() {
    }

    public static void testMobFarmBlockItem(GameTestHelper helper, Item item, Block block) {
        MobFarmBlockItemTestHelper.useMobFarmBlockItem(helper, new ItemStack((ItemLike)item), block, new BlockPos(0, 1, 0));
    }

    public static void useMobFarmBlockItem(GameTestHelper helper, Item item, int tierLevel, Block block) {
        BlockPos blockPose = new BlockPos(0, 1, 0);
        ItemStack itemStack = new ItemStack((ItemLike)item);
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128405_("TierLevel", tierLevel);
        tag.m_128405_("CustomModelData", tierLevel);
        itemStack.m_41751_(tag);
        MobFarmBlockItemTestHelper.useMobFarmBlockItem(helper, itemStack, block, blockPose);
        BlockState blockState = helper.m_177232_(blockPose);
        GameTestHelpers.assertTrue(helper, "Expected tier level " + tierLevel + " but found " + MobFarmBlock.getTierLevel(blockState), MobFarmBlock.getTierLevel(blockState) == tierLevel);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void useMobFarmBlockItem(GameTestHelper helper, ItemStack itemStack, Block block, BlockPos blockPose) {
        Item item = itemStack.m_41720_();
        if (item instanceof MobFarmBlockItem) {
            MobFarmBlockItem mobFarmBlockItem = (MobFarmBlockItem)item;
            if (block instanceof MobFarmBlock) {
                MobFarmBlock mobFarmBlock = (MobFarmBlock)block;
                MobFarmBlockItemTestHelper.useMobFarmBlockItem(helper, itemStack, mobFarmBlock, blockPose);
                return;
            }
        }
        helper.m_177284_("Item " + itemStack.m_41720_() + " is not a MobFarmBlockItem or Block " + block + " is not a MobFarmBlock");
    }

    public static void useMobFarmBlockItem(GameTestHelper helper, ItemStack mobFarmBlockItemStack, MobFarmBlock mobFarmBlock, BlockPos blockPose) {
        Player player = helper.m_177368_();
        player.m_21008_(player.m_7655_(), mobFarmBlockItemStack);
        UseOnContext useOnContext = new UseOnContext(player, player.m_7655_(), new BlockHitResult(helper.m_177227_(new Vec3((double)blockPose.m_123341_(), (double)blockPose.m_123342_(), (double)blockPose.m_123343_())), Direction.UP, helper.m_177449_(blockPose), false));
        mobFarmBlockItemStack.m_41661_(useOnContext);
        helper.m_177208_((Block)mobFarmBlock, blockPose);
    }
}

