/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.ability;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.everlastingabilities.GeneralConfig;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.AbilityTypes;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.core.helper.WorldHelpers;
import org.cyclops.everlastingabilities.item.ItemAbilityTotem;

public class AbilityHelpers {
    public static int maxPlayerAbilitiesClient = -1;
    public static final int[] RARITY_COLORS = new int[]{Helpers.RGBToInt((int)255, (int)255, (int)255), Helpers.RGBToInt((int)255, (int)255, (int)0), Helpers.RGBToInt((int)0, (int)255, (int)255), Helpers.RGBToInt((int)255, (int)0, (int)255)};
    public static Predicate<IAbilityType> PREDICATE_ABILITY_ENABLED = ability -> ability.getCondition().test(ICondition.IContext.EMPTY);

    public static Registry<IAbilityType> getRegistry(RegistryAccess registryAccess) {
        return registryAccess.m_175515_(AbilityTypes.REGISTRY_KEY);
    }

    public static Registry<IAbilityType> getRegistry() {
        return AbilityHelpers.getRegistry(WorldHelpers.getRegistryAccess());
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level < 16) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level < 32) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }

    public static int getLevelForExperience(int experience) {
        int newXp;
        int i = 0;
        int lastXp = -1;
        while ((newXp = AbilityHelpers.getExperienceForLevel(i)) <= experience && newXp > lastXp) {
            ++i;
            lastXp = newXp;
        }
        return i - 1;
    }

    public static Predicate<IAbilityType> createRarityPredicate(Rarity rarity) {
        return abilityType -> abilityType.getRarity() == rarity;
    }

    public static List<IAbilityType> getAbilityTypes(Registry<IAbilityType> registry, Predicate<IAbilityType> abilityFilter) {
        return registry.m_123024_().filter(abilityFilter).collect(Collectors.toList());
    }

    public static List<IAbilityType> getAbilityTypesPlayerSpawn(Registry<IAbilityType> registry) {
        return AbilityHelpers.getAbilityTypes(registry, PREDICATE_ABILITY_ENABLED.and(IAbilityType::isObtainableOnPlayerSpawn));
    }

    public static List<IAbilityType> getAbilityTypesMobSpawn(Registry<IAbilityType> registry) {
        return AbilityHelpers.getAbilityTypes(registry, PREDICATE_ABILITY_ENABLED.and(IAbilityType::isObtainableOnMobSpawn));
    }

    public static List<IAbilityType> getAbilityTypesCrafting(Registry<IAbilityType> registry) {
        return AbilityHelpers.getAbilityTypes(registry, PREDICATE_ABILITY_ENABLED.and(IAbilityType::isObtainableOnCraft));
    }

    public static List<IAbilityType> getAbilityTypesLoot(Registry<IAbilityType> registry) {
        return AbilityHelpers.getAbilityTypes(registry, PREDICATE_ABILITY_ENABLED.and(IAbilityType::isObtainableOnLoot));
    }

    public static void onPlayerAbilityChanged(Player player, IAbilityType abilityType, int oldLevel, int newLevel) {
        abilityType.onChangedLevel(player, oldLevel, newLevel);
    }

    public static int getMaxPlayerAbilities(Level world) {
        return world.m_5776_() ? maxPlayerAbilitiesClient : GeneralConfig.maxPlayerAbilities;
    }

    @NonNull
    public static Ability addPlayerAbility(Player player, Ability ability, boolean doAdd, boolean modifyXp) {
        return player.getCapability(MutableAbilityStoreConfig.CAPABILITY).map(abilityStore -> {
            int oldLevel;
            int n = oldLevel = abilityStore.hasAbilityType(ability.getAbilityType()) ? abilityStore.getAbility(ability.getAbilityType()).getLevel() : 0;
            if (AbilityHelpers.getMaxPlayerAbilities(player.m_20193_()) >= 0 && oldLevel == 0 && AbilityHelpers.getMaxPlayerAbilities(player.m_20193_()) <= abilityStore.getAbilities().size()) {
                return Ability.EMPTY;
            }
            Ability result = abilityStore.addAbility(ability, doAdd);
            int currentXp = player.f_36079_;
            if (result != null && modifyXp && AbilityHelpers.getExperience(result) > currentXp) {
                int maxLevels = player.f_36079_ / result.getAbilityType().getXpPerLevelScaled();
                result = maxLevels == 0 ? Ability.EMPTY : new Ability(result.getAbilityType(), maxLevels);
            }
            if (doAdd && !result.isEmpty()) {
                player.f_36079_ -= AbilityHelpers.getExperience(result);
                player.f_36078_ = AbilityHelpers.getLevelForExperience(player.f_36079_);
                int xpForLevel = AbilityHelpers.getExperienceForLevel(player.f_36078_);
                player.f_36080_ = (float)(player.f_36079_ - xpForLevel) / (float)player.m_36323_();
                int newLevel = abilityStore.getAbility(result.getAbilityType()).getLevel();
                AbilityHelpers.onPlayerAbilityChanged(player, result.getAbilityType(), oldLevel, newLevel);
            }
            return result;
        }).orElse(Ability.EMPTY);
    }

    @NonNull
    public static Ability removePlayerAbility(Player player, Ability ability, boolean doRemove, boolean modifyXp) {
        return player.getCapability(MutableAbilityStoreConfig.CAPABILITY, null).map(abilityStore -> {
            int oldLevel = abilityStore.hasAbilityType(ability.getAbilityType()) ? abilityStore.getAbility(ability.getAbilityType()).getLevel() : 0;
            Ability result = abilityStore.removeAbility(ability, doRemove);
            if (modifyXp && !result.isEmpty()) {
                player.m_6756_(AbilityHelpers.getExperience(result));
                int newLevel = abilityStore.hasAbilityType(result.getAbilityType()) ? abilityStore.getAbility(result.getAbilityType()).getLevel() : 0;
                AbilityHelpers.onPlayerAbilityChanged(player, result.getAbilityType(), oldLevel, newLevel);
            }
            return result;
        }).orElse(Ability.EMPTY);
    }

    public static int getExperience(@NonNull Ability ability) {
        if (ability == null) {
            throw new NullPointerException("ability is marked non-null but is null");
        }
        if (ability.isEmpty()) {
            return 0;
        }
        return ability.getAbilityType().getXpPerLevelScaled() * ability.getLevel();
    }

    public static void setPlayerAbilities(ServerPlayer player, Map<IAbilityType, Integer> abilityTypes) {
        player.getCapability(MutableAbilityStoreConfig.CAPABILITY).ifPresent(abilityStore -> abilityStore.setAbilities(abilityTypes));
    }

    public static boolean canInsert(Ability ability, IMutableAbilityStore mutableAbilityStore) {
        Ability added = mutableAbilityStore.addAbility(ability, false);
        return added.getLevel() == ability.getLevel();
    }

    public static boolean canExtract(Ability ability, IMutableAbilityStore mutableAbilityStore) {
        Ability added = mutableAbilityStore.removeAbility(ability, false);
        return added.getLevel() == ability.getLevel();
    }

    public static boolean canInsertToPlayer(Ability ability, Player player) {
        Ability added = AbilityHelpers.addPlayerAbility(player, ability, false, true);
        return added.getLevel() == ability.getLevel();
    }

    public static Ability insert(Ability ability, IMutableAbilityStore mutableAbilityStore) {
        return mutableAbilityStore.addAbility(ability, true);
    }

    public static Ability extract(Ability ability, IMutableAbilityStore mutableAbilityStore) {
        return mutableAbilityStore.removeAbility(ability, true);
    }

    public static Optional<IAbilityType> getRandomAbility(List<IAbilityType> abilityTypes, RandomSource random, Rarity rarity) {
        List filtered = abilityTypes.stream().filter(AbilityHelpers.createRarityPredicate(rarity)).collect(Collectors.toList());
        if (filtered.size() > 0) {
            return Optional.of((IAbilityType)filtered.get(random.m_188503_(filtered.size())));
        }
        return Optional.empty();
    }

    public static Optional<IAbilityType> getRandomAbilityUntilRarity(List<IAbilityType> abilityTypes, RandomSource random, Rarity rarity, boolean inclusive) {
        NavigableSet<Rarity> validRarities = AbilityHelpers.getValidAbilityRarities(abilityTypes).headSet(rarity, inclusive);
        Iterator<Rarity> it = validRarities.descendingIterator();
        while (it.hasNext()) {
            Optional<IAbilityType> optional = AbilityHelpers.getRandomAbility(abilityTypes, random, it.next());
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> getRandomTotem(List<IAbilityType> abilityTypes, Rarity rarity, RandomSource rand) {
        return AbilityHelpers.getRandomAbility(abilityTypes, rand, rarity).flatMap(abilityType -> Optional.of(ItemAbilityTotem.getTotem(new Ability((IAbilityType)abilityType, 1))));
    }

    public static Optional<Rarity> getRandomRarity(List<IAbilityType> abilityTypes, RandomSource rand) {
        int chance = rand.m_188503_(50);
        Rarity rarity = chance >= 49 ? Rarity.EPIC : (chance >= 40 ? Rarity.RARE : (chance >= 25 ? Rarity.UNCOMMON : Rarity.COMMON));
        if (!AbilityHelpers.hasRarityAbilities(abilityTypes, rarity)) {
            int size = abilityTypes.size();
            if (size == 0) {
                return Optional.empty();
            }
            rarity = ((IAbilityType)Iterables.get(abilityTypes, (int)rand.m_188503_(size))).getRarity();
        }
        return Optional.of(rarity);
    }

    public static boolean hasRarityAbilities(List<IAbilityType> abilityTypes, Rarity rarity) {
        return abilityTypes.stream().anyMatch(AbilityHelpers.createRarityPredicate(rarity));
    }

    public static NavigableSet<Rarity> getValidAbilityRarities(List<IAbilityType> abilityTypes) {
        TreeSet rarities = Sets.newTreeSet();
        for (Rarity rarity : Rarity.values()) {
            if (!AbilityHelpers.hasRarityAbilities(abilityTypes, rarity)) continue;
            rarities.add(rarity);
        }
        return rarities;
    }

    public static Triple<Integer, Integer, Integer> getAverageRarityColor(IAbilityStore abilityStore) {
        int r = 0;
        int g = 0;
        int b = 0;
        int count = 1;
        for (IAbilityType abilityType : abilityStore.getAbilityTypes()) {
            Triple color = Helpers.intToRGB((int)RARITY_COLORS[Math.min(RARITY_COLORS.length - 1, abilityType.getRarity().ordinal())]);
            r = (int)((float)r + ((Float)color.getLeft()).floatValue() * 255.0f);
            g = (int)((float)g + ((Float)color.getMiddle()).floatValue() * 255.0f);
            b = (int)((float)b + ((Float)color.getRight()).floatValue() * 255.0f);
            ++count;
        }
        return Triple.of((Object)(r / count), (Object)(g / count), (Object)(b / count));
    }

    public static Supplier<Rarity> getSafeRarity(Supplier<Integer> rarityGetter) {
        return () -> {
            Integer rarity = (Integer)rarityGetter.get();
            return rarity < 0 ? Rarity.COMMON : (rarity >= Rarity.values().length ? Rarity.EPIC : Rarity.values()[rarity]);
        };
    }
}

