/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.inventory.container;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.container.ItemInventoryContainer;
import org.cyclops.everlastingabilities.RegistryEntries;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStoreRegistryAccess;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.client.gui.ContainerScreenAbilityContainer;
import org.cyclops.everlastingabilities.item.ItemGuiAbilityContainer;

public class ContainerAbilityContainer
extends ItemInventoryContainer<ItemGuiAbilityContainer> {
    @OnlyIn(value=Dist.CLIENT)
    private ContainerScreenAbilityContainer gui;

    public ContainerAbilityContainer(int id, Inventory inventory, FriendlyByteBuf packetBuffer) {
        this(id, inventory, ItemLocation.readFromPacketBuffer((FriendlyByteBuf)packetBuffer));
    }

    public ContainerAbilityContainer(int id, Inventory inventory, ItemLocation itemLocation) {
        super(RegistryEntries.CONTAINER_ABILITYCONTAINER, id, inventory, itemLocation);
        this.addInventory((Container)inventory, 0, 8, 195, 1, 9);
        int level = AbilityHelpers.getLevelForExperience(this.player.f_36079_);
        if (this.player.f_36078_ != level) {
            this.player.f_36079_ = AbilityHelpers.getExperienceForLevel(this.player.f_36078_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setGui(ContainerScreenAbilityContainer gui) {
        this.gui = gui;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ContainerScreenAbilityContainer getGui() {
        return this.gui;
    }

    protected int getSizeInventory() {
        return 0;
    }

    public LazyOptional<IMutableAbilityStore> getPlayerAbilityStore() {
        return this.player.getCapability(MutableAbilityStoreConfig.CAPABILITY);
    }

    public LazyOptional<IMutableAbilityStore> getItemAbilityStore() {
        ItemStack itemStack = this.getItemStack(this.player);
        if (itemStack.m_41619_()) {
            return LazyOptional.empty();
        }
        return itemStack.getCapability(MutableAbilityStoreConfig.CAPABILITY).lazyMap(store -> {
            ((IMutableAbilityStoreRegistryAccess)store).setRegistryAccess(this.player.m_9236_().m_9598_());
            return store;
        });
    }

    public List<Ability> getPlayerAbilities() {
        return this.getPlayerAbilityStore().map(abilityStore -> Lists.newArrayList(abilityStore.getAbilities())).orElseGet(Collections::emptyList);
    }

    public List<Ability> getItemAbilities() {
        return this.getItemAbilityStore().map(abilityStore -> Lists.newArrayList(abilityStore.getAbilities())).orElseGet(Collections::emptyList);
    }

    public void moveFromPlayer(Ability playerAbility) {
        this.getItemAbilityStore().ifPresent(abilityStore -> {
            Ability insertedAbility = AbilityHelpers.insert(playerAbility, abilityStore);
            if (!insertedAbility.isEmpty()) {
                AbilityHelpers.removePlayerAbility(this.player, insertedAbility, true, true);
            }
        });
    }

    public void moveToPlayer(Ability itemAbility) {
        this.getItemAbilityStore().ifPresent(abilityStore -> {
            Ability insertedAbility = AbilityHelpers.addPlayerAbility(this.player, itemAbility, true, true);
            if (!insertedAbility.isEmpty()) {
                AbilityHelpers.extract(insertedAbility, abilityStore);
                if (this.getItemAbilities().isEmpty() && !((ItemGuiAbilityContainer)this.getItem()).canMoveFromPlayer()) {
                    this.itemLocation.setItemStack(this.player, ItemStack.f_41583_);
                }
            }
        });
    }

    public boolean m_6875_(Player player) {
        return !this.getItemStack(player).m_41619_() && (((ItemGuiAbilityContainer)this.getItem()).canMoveFromPlayer() || !this.getItemAbilities().isEmpty());
    }
}

