/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.blockentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.blockentity.IBlockEntityDelayedTickable;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;

public class CyclopsBlockEntity
extends BlockEntity
implements INBTProvider,
IDirtyMarkListener,
IBlockEntityDelayedTickable {
    private static final int UPDATE_BACKOFF_TICKS = 1;
    private INBTProvider nbtProviderComponent = new NBTProviderComponent(this);
    private boolean shouldSendUpdate = false;
    private int sendUpdateBackoff = 0;
    private Map<Pair<Capability<?>, Direction>, LazyOptional<?>> capabilities = Maps.newHashMap();

    public CyclopsBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.sendUpdateBackoff = (int)Math.round(Math.random() * (double)this.getUpdateBackoffTicks());
    }

    @Override
    public int getUpdateBackoffTicks() {
        return 1;
    }

    @Override
    public void sendUpdate() {
        this.shouldSendUpdate = true;
    }

    @Override
    public boolean shouldSendUpdate() {
        return this.shouldSendUpdate;
    }

    @Override
    public void unsetSendUpdate() {
        this.shouldSendUpdate = false;
    }

    @Override
    public void setUpdateBackoff(int updateBackoff) {
        this.sendUpdateBackoff = updateBackoff;
    }

    @Override
    public int getUpdateBackoff() {
        return this.sendUpdateBackoff;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        CompoundTag tag = packet.m_131708_();
        this.read(tag);
        this.onUpdateReceived();
    }

    public void onUpdateReceived() {
    }

    public boolean canInteractWith(Player entityPlayer) {
        return true;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeGeneratedFieldsToNBT(tag);
    }

    public CompoundTag writeToItemStack(CompoundTag tag) {
        this.m_183515_(tag);
        return tag;
    }

    public final void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.read(tag);
    }

    public void read(CompoundTag tag) {
        this.readGeneratedFieldsFromNBT(tag);
        this.onLoad();
    }

    public void onLoad() {
        if (this.capabilities instanceof HashMap) {
            this.capabilities = ImmutableMap.copyOf(this.capabilities);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected Direction transformFacingForRotation(Direction facing) {
        if (facing == null) {
            return null;
        }
        if (this.getRotation() == null) {
            return facing;
        }
        return DirectionHelpers.transformFacingForRotation(facing, this.getRotation());
    }

    public Direction getRotation() {
        return null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (this.capabilities != null) {
            LazyOptional<?> value = this.capabilities.get(Pair.of(capability, (Object)this.transformFacingForRotation(facing)));
            if (value == null && facing != null) {
                value = this.capabilities.get(Pair.of(capability, null));
            }
            if (value != null) {
                return value.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<?> lazyOptional : this.capabilities.values()) {
            lazyOptional.invalidate();
        }
    }

    public <T> void addCapabilityInternal(Capability<T> capability, LazyOptional<T> value) {
        this.capabilities.put(Pair.of(capability, null), value);
    }

    public <T> void addCapabilitySided(Capability<T> capability, Direction facing, LazyOptional<T> value) {
        this.capabilities.put(Pair.of(capability, (Object)facing), value);
    }

    protected Map<Pair<Capability<?>, Direction>, LazyOptional<?>> getStoredCapabilities() {
        return this.capabilities;
    }

    @Override
    public void onDirty() {
        this.m_6596_();
    }

    @Override
    public void writeGeneratedFieldsToNBT(CompoundTag tag) {
        this.nbtProviderComponent.writeGeneratedFieldsToNBT(tag);
    }

    @Override
    public void readGeneratedFieldsFromNBT(CompoundTag tag) {
        this.nbtProviderComponent.readGeneratedFieldsFromNBT(tag);
    }
}

