/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityHelpers {
    public static final String NBTTAG_ID = "id";

    public static void onEntityCollided(Level world, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (blockPos != null) {
            Block block = world.m_8055_(blockPos).m_60734_();
            block.m_141947_(world, blockPos, blockState, entity);
        }
    }

    public static List<Entity> getEntitiesInArea(Level world, BlockPos blockPos, int area) {
        AABB box = new AABB((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()).m_82377_((double)area, (double)area, (double)area);
        List entities = world.m_45976_(Entity.class, box);
        return entities;
    }

    public static Optional<Entity> spawnEntity(Level world, @Nullable ResourceLocation entityName, double x, double y, double z) {
        return EntityType.m_20632_((String)entityName.toString()).map(type -> {
            Entity entity = type.m_20615_(world);
            entity.m_6034_(x, y, z);
            world.m_7967_(entity);
            return entity;
        });
    }

    public static boolean spawnEntity(ServerLevel world, Mob entityLiving, MobSpawnType spawnReason) {
        SpawnGroupData spawnData = ForgeEventFactory.onFinalizeSpawn((Mob)entityLiving, (ServerLevelAccessor)world, (DifficultyInstance)world.m_6436_(entityLiving.m_20183_()), (MobSpawnType)spawnReason, (SpawnGroupData)new SpawnGroupData(){}, null);
        if (spawnData != null) {
            world.m_7967_((Entity)entityLiving);
            return true;
        }
        return false;
    }

    public static Vec3i getEntitySize(Entity entity) {
        int x = (int)Math.ceil(entity.m_20205_());
        int y = (int)Math.ceil(entity.m_20206_());
        int z = x;
        return new Vec3i(x, y, z);
    }

    public static void spawnXpAtPlayer(Level world, Player player, int xp) {
        if (!world.m_5776_()) {
            while (xp > 0) {
                int current = ExperienceOrb.m_20782_((int)xp);
                xp -= current;
                world.m_7967_((Entity)new ExperienceOrb(world, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_() + 0.5, current));
            }
        }
    }

    public static CompoundTag getPersistedPlayerNbt(Player player) {
        CompoundTag tag = player.getPersistentData();
        CompoundTag persistedTag = tag.m_128469_("PlayerPersisted");
        if (persistedTag == null) {
            persistedTag = new CompoundTag();
            tag.m_128365_("PlayerPersisted", (Tag)persistedTag);
        }
        return persistedTag;
    }
}

