/*
 * Decompiled with CFR 0.152.
 */
package net.walksantor.hextweaks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.walksantor.hextweaks.HexTweaksCommands;
import net.walksantor.hextweaks.HexTweaksConfig;
import net.walksantor.hextweaks.MojankResetChunk;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vazkii.patchouli.api.PatchouliAPI;

public class HexTweaks {
    public static final String MOD_ID = "hextweaks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"hextweaks");
    @Nullable
    public static HexTweaksConfig CONFIG = null;

    public static void breakpoint() {
        LOGGER.info("breakpoints sometimes fail. call me instead!");
        new Exception("Breakpoint").printStackTrace();
    }

    public static void init() {
        LOGGER.info("performing COMMON setup");
        CommandRegistrationEvent.EVENT.register((it, b, c) -> HexTweaksCommands.register((CommandDispatcher<CommandSourceStack>)it));
        Path res = Platform.getConfigFolder().resolve("hextweaks.json");
        Gson gson = new GsonBuilder().setLenient().create();
        if (Files.exists(res, new LinkOption[0])) {
            try {
                String json = Strings.join(Files.readAllLines(res).iterator(), (char)'\n');
                CONFIG = (HexTweaksConfig)gson.fromJson(json, HexTweaksConfig.class);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load hextweaks config");
                e.printStackTrace();
                CONFIG = new HexTweaksConfig();
            }
        } else {
            CONFIG = new HexTweaksConfig();
        }
        LifecycleEvent.SERVER_STOPPING.register(it -> {
            try {
                Files.writeString(res, (CharSequence)gson.toJson((Object)CONFIG), new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("failed to write config");
                e.printStackTrace();
            }
        });
        if (Platform.isModLoaded((String)"computercraft")) {
            PatchouliAPI.get().setConfigFlag("hexcasting:any_interop", true);
        }
        if (Platform.isModLoaded((String)"worldedit")) {
            TickEvent.SERVER_POST.register(server -> MojankResetChunk.step());
        }
    }
}

