/*
 * Decompiled with CFR 0.152.
 */
package net.walksantor.hextweaks.casting;

import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.ktxt.AccessorWrappers;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.npc.Villager;
import net.walksantor.hextweaks.HexTweaks;
import net.walksantor.hextweaks.HexTweaksConfig;
import net.walksantor.hextweaks.casting.mindflay.MindflayInput;
import net.walksantor.hextweaks.casting.mindflay.MindflayResult;
import net.walksantor.hextweaks.casting.mindflay.MindflaySlipwayRitual;
import net.walksantor.hextweaks.casting.mindflay.RestockingRitual;
import net.walksantor.hextweaks.casting.mindflay.StartResetChunkRitual;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0013\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00172\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0019\u0010\u001aJ)\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\f\u00a2\u0006\u0004\b \u0010\u0003RH\u0010#\u001a6\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001c0\u001b0!j\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001c0\u001b`\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lnet/walksantor/hextweaks/casting/MindflayRegistry;", "", "<init>", "()V", "", "Lnet/minecraft/world/entity/Entity;", "entities", "", "calcuateVillagerPoints", "(Ljava/util/List;)I", "Lnet/minecraft/resources/ResourceLocation;", "key", "", "del", "(Lnet/minecraft/resources/ResourceLocation;)V", "Lnet/minecraft/world/entity/Mob;", "inputs", "Lnet/minecraft/server/level/ServerPlayer;", "caster", "performBrainsweeps", "(Ljava/util/List;Lnet/minecraft/server/level/ServerPlayer;)V", "Lnet/walksantor/hextweaks/casting/mindflay/MindflayInput;", "input", "Lkotlin/Pair;", "", "performMindflays", "(Lnet/walksantor/hextweaks/casting/mindflay/MindflayInput;)Lkotlin/Pair;", "Ljava/util/function/Function;", "Lnet/walksantor/hextweaks/casting/mindflay/MindflayResult;", "func", "put", "(Lnet/minecraft/resources/ResourceLocation;Ljava/util/function/Function;)V", "register", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "functions", "Ljava/util/HashMap;", "hextweaks"})
@SourceDebugExtension(value={"SMAP\nMindflayRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MindflayRegistry.kt\nnet/walksantor/hextweaks/casting/MindflayRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n800#2,11:100\n766#2:111\n857#2,2:112\n1855#2,2:114\n*S KotlinDebug\n*F\n+ 1 MindflayRegistry.kt\nnet/walksantor/hextweaks/casting/MindflayRegistry\n*L\n56#1:100,11\n56#1:111\n56#1:112,2\n56#1:114,2\n*E\n"})
public final class MindflayRegistry {
    @NotNull
    public static final MindflayRegistry INSTANCE = new MindflayRegistry();
    @NotNull
    private static final HashMap<ResourceLocation, Function<MindflayInput, MindflayResult>> functions = new HashMap();

    private MindflayRegistry() {
    }

    @NotNull
    public final Pair<Boolean, ResourceLocation> performMindflays(@NotNull MindflayInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        for (Map.Entry kv : ((Map)functions).entrySet()) {
            Object r = ((Function)kv.getValue()).apply(input);
            Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
            MindflayResult res = (MindflayResult)r;
            if (!res.getSucceeded()) continue;
            return new Pair((Object)true, kv.getKey());
        }
        return new Pair((Object)false, null);
    }

    public final void put(@NotNull ResourceLocation key, @NotNull Function<MindflayInput, MindflayResult> func) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        if (functions.containsKey(key)) {
            String string = "cannot register %s as %s is allready registered";
            Object[] objectArray = new Object[]{key, key};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new IllegalArgumentException(string2);
        }
        ((Map)functions).put(key, func);
    }

    public final void del(@NotNull ResourceLocation key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!functions.containsKey(key)) {
            String string = "cannot unregister %s as %s is not registered";
            Object[] objectArray = new Object[]{key, key};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new IllegalArgumentException(string2);
        }
        functions.remove(key);
    }

    /*
     * WARNING - void declaration
     */
    public final int calcuateVillagerPoints(@NotNull List<? extends Entity> entities) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(entities, (String)"entities");
        double accu = 0.0;
        Iterable $this$filterIsInstance$iv = entities;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Villager)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Villager it = (Villager)element$iv$iv;
            boolean bl = false;
            if (!(!IXplatAbstractions.INSTANCE.isBrainswept((Mob)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Villager it = (Villager)element$iv;
            boolean bl = false;
            accu += Math.pow(2.0, it.m_7141_().m_35576_());
        }
        return (int)accu;
    }

    public final void performBrainsweeps(@NotNull List<? extends Mob> inputs, @Nullable ServerPlayer caster) {
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        boolean alert = HexConfig.server().doVillagersTakeOffenseAtMindMurder();
        for (Mob mob : inputs) {
            IXplatAbstractions.INSTANCE.setBrainsweepAddlData(mob);
            if (!(mob instanceof Villager) || !alert || caster == null) continue;
            AccessorWrappers.tellWitnessesThatIWasMurdered((Villager)((Villager)mob), (Entity)((Entity)caster));
        }
    }

    public final void register() {
        HexTweaksConfig hexTweaksConfig = HexTweaks.CONFIG;
        Intrinsics.checkNotNull((Object)hexTweaksConfig);
        if (hexTweaksConfig.getEnableChunkreset()) {
            this.put(new ResourceLocation("hextweaks", "reset_chunk"), StartResetChunkRitual.INSTANCE::start);
        }
        if (Platform.isModLoaded((String)"hexal")) {
            this.put(new ResourceLocation("hextweaks", "slipway/create"), MindflaySlipwayRitual.INSTANCE::createSlipway);
            this.put(new ResourceLocation("hextweaks", "slipway/destroy"), MindflaySlipwayRitual.INSTANCE::burstSlipway);
        }
        this.put(new ResourceLocation("hextweaks", "restock"), RestockingRitual.INSTANCE::restockVillager);
    }
}

