/*
 * Decompiled with CFR 0.152.
 */
package net.walksantor.hextweaks.casting.actions;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadBlock;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.blocks.BlockConjured;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\u00020\f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lnet/walksantor/hextweaks/casting/actions/OpConjureButton;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "<init>", "()V", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "args", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "execute", "(Ljava/util/List;Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "", "argc", "I", "getArgc", "()I", "Spell", "hextweaks"})
public final class OpConjureButton
implements SpellAction {
    private final int argc;

    public OpConjureButton() {
        this.argc = 3;
    }

    public int getArgc() {
        return this.argc;
    }

    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Vec3 vecPos = OperatorUtils.getVec3(args, (int)0, (int)this.getArgc());
        Vec3 direction = OperatorUtils.getVec3(args, (int)1, (int)this.getArgc());
        double media = OperatorUtils.getDouble(args, (int)2, (int)this.getArgc());
        Direction placedir = Direction.m_122366_((double)direction.f_82479_, (double)direction.f_82480_, (double)direction.f_82481_);
        BlockPos pos = BlockPos.m_274446_((Position)((Position)vecPos));
        env.assertPosInRangeForEditing(pos);
        DirectionalPlaceContext placeContext = new DirectionalPlaceContext((Level)env.getWorld(), pos, placedir, ItemStack.f_41583_, placedir.m_122424_());
        BlockState worldState = env.getWorld().m_8055_(pos);
        if (!worldState.m_60629_((BlockPlaceContext)placeContext)) {
            Intrinsics.checkNotNull((Object)pos);
            throw MishapBadBlock.Companion.of(pos, "replaceable");
        }
        Intrinsics.checkNotNull((Object)pos);
        Intrinsics.checkNotNull((Object)placedir);
        RenderedSpell renderedSpell = new Spell(pos, placedir, media);
        long l = 10000L + (long)((double)10000L * media);
        Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)pos));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(...)");
        return new SpellAction.Result(renderedSpell, l, CollectionsKt.listOf((Object)ParticleSpray.Companion.cloud$default((ParticleSpray.Companion)ParticleSpray.Companion, (Vec3)vec3, (double)1.0, (int)0, (int)4, null)), 0L, 8, null);
    }

    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata((SpellAction)this, args, (CastingEnvironment)env, (CompoundTag)userData);
    }

    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate((SpellAction)this, (CastingEnvironment)env, (CastingImage)image, (SpellContinuation)continuation);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J.\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010 \u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\"\u001a\u0004\b#\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010$\u001a\u0004\b%\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010\u0010\u00a8\u0006("}, d2={"Lnet/walksantor/hextweaks/casting/actions/OpConjureButton$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/core/Direction;", "direction", "", "dust", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;D)V", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "", "cast", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)V", "component1", "()Lnet/minecraft/core/BlockPos;", "component2", "()Lnet/minecraft/core/Direction;", "component3", "()D", "copy", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;D)Lnet/walksantor/hextweaks/casting/actions/OpConjureButton$Spell;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/core/Direction;", "getDirection", "D", "getDust", "Lnet/minecraft/core/BlockPos;", "getPos", "hextweaks"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final BlockPos pos;
        @NotNull
        private final Direction direction;
        private final double dust;

        public Spell(@NotNull BlockPos pos, @NotNull Direction direction, double dust) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            this.pos = pos;
            this.direction = direction;
            this.dust = dust;
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        public final double getDust() {
            return this.dust;
        }

        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (!env.canEditBlockAt(this.pos)) {
                return;
            }
            DirectionalPlaceContext placeContext = new DirectionalPlaceContext((Level)env.getWorld(), this.pos, this.direction, ItemStack.f_41583_, this.direction.m_122424_());
            BlockState worldState = env.getWorld().m_8055_(this.pos);
            if (worldState.m_60629_((BlockPlaceContext)placeContext)) {
                Block block = Blocks.f_50016_;
                if (!IXplatAbstractions.INSTANCE.isPlacingAllowed(env.getWorld(), this.pos, new ItemStack((ItemLike)block), (Player)env.getCaster())) {
                    return;
                }
                BlockState state = block.m_5573_((BlockPlaceContext)placeContext);
                if (state != null) {
                    env.getWorld().m_7731_(this.pos, state, 5);
                    FrozenPigment pigment = env.getPigment();
                    if (env.getWorld().m_8055_(this.pos).m_60734_() instanceof BlockConjured) {
                        BlockConjured.setColor((LevelAccessor)((LevelAccessor)env.getWorld()), (BlockPos)this.pos, (FrozenPigment)pigment);
                    }
                }
            }
        }

        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast((RenderedSpell)this, (CastingEnvironment)env, (CastingImage)image);
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        @NotNull
        public final Direction component2() {
            return this.direction;
        }

        public final double component3() {
            return this.dust;
        }

        @NotNull
        public final Spell copy(@NotNull BlockPos pos, @NotNull Direction direction, double dust) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            return new Spell(pos, direction, dust);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, BlockPos blockPos, Direction direction, double d, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = spell.pos;
            }
            if ((n & 2) != 0) {
                direction = spell.direction;
            }
            if ((n & 4) != 0) {
                d = spell.dust;
            }
            return spell.copy(blockPos, direction, d);
        }

        @NotNull
        public String toString() {
            return "Spell(pos=" + this.pos + ", direction=" + this.direction + ", dust=" + this.dust + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + this.direction.hashCode();
            result = result * 31 + Double.hashCode(this.dust);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)spell.pos)) {
                return false;
            }
            if (this.direction != spell.direction) {
                return false;
            }
            return Double.compare(this.dust, spell.dust) == 0;
        }
    }
}

