/*
 * Decompiled with CFR 0.152.
 */
package net.walksantor.hextweaks.casting.mindflay;

import at.petrak.hexcasting.api.casting.iota.EntityIota;
import at.petrak.hexcasting.api.casting.iota.Vec3Iota;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.walksantor.hextweaks.casting.MindflayRegistry;
import net.walksantor.hextweaks.casting.mindflay.MindflayInput;
import net.walksantor.hextweaks.casting.mindflay.MindflayResult;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.common.entities.BaseWisp;
import ram.talia.hexal.common.entities.WanderingWisp;
import ram.talia.hexal.common.lib.HexalBlocks;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lnet/walksantor/hextweaks/casting/mindflay/MindflaySlipwayRitual;", "", "<init>", "()V", "Lnet/walksantor/hextweaks/casting/mindflay/MindflayInput;", "input", "Lnet/walksantor/hextweaks/casting/mindflay/MindflayResult;", "burstSlipway", "(Lnet/walksantor/hextweaks/casting/mindflay/MindflayInput;)Lnet/walksantor/hextweaks/casting/mindflay/MindflayResult;", "createSlipway", "hextweaks"})
public final class MindflaySlipwayRitual {
    @NotNull
    public static final MindflaySlipwayRitual INSTANCE = new MindflaySlipwayRitual();

    private MindflaySlipwayRitual() {
    }

    @NotNull
    public final MindflayResult createSlipway(@NotNull MindflayInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(input.getTarget() instanceof EntityIota)) {
            return new MindflayResult(false);
        }
        Entity entity = ((EntityIota)input.getTarget()).getEntity();
        if (!(entity instanceof BaseWisp)) {
            return new MindflayResult(false);
        }
        int points = MindflayRegistry.INSTANCE.calcuateVillagerPoints(input.getInputs());
        if (points < 80) {
            return new MindflayResult(false);
        }
        BlockState block = input.getEnv().getWorld().m_8055_(entity.m_20183_());
        if (!block.m_60795_()) {
            return new MindflayResult(false);
        }
        input.getEnv().getWorld().m_7731_(entity.m_20183_(), HexalBlocks.SLIPWAY.defaultBlockState(), 1);
        MindflayRegistry.INSTANCE.performBrainsweeps(input.getInputs(), input.getEnv().getCaster());
        return new MindflayResult(true);
    }

    @NotNull
    public final MindflayResult burstSlipway(@NotNull MindflayInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(input.getTarget() instanceof Vec3Iota)) {
            return new MindflayResult(false);
        }
        Vec3 pos = ((Vec3Iota)input.getTarget()).getVec3();
        if (input.getEnv().isVecInRange(pos)) {
            return new MindflayResult(false);
        }
        ServerLevel world = input.getEnv().getWorld();
        BlockPos bpos = new BlockPos((int)pos.m_7096_(), (int)pos.m_7098_(), (int)pos.m_7094_());
        int points = MindflayRegistry.INSTANCE.calcuateVillagerPoints(input.getInputs());
        if (points < 16) {
            return new MindflayResult(false);
        }
        BlockState state = world.m_8055_(bpos);
        if (!Intrinsics.areEqual((Object)state.m_60734_(), (Object)HexalBlocks.SLIPWAY)) {
            return new MindflayResult(false);
        }
        world.m_7731_(bpos, Blocks.f_50626_.m_49966_(), 1);
        int x = 0;
        int n = 10 + Random.Default.nextInt(10, 20);
        if (x <= n) {
            while (true) {
                Intrinsics.checkNotNull((Object)world);
                Level level = (Level)world;
                Vec3 vec3 = bpos.m_252807_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
                WanderingWisp wisp = new WanderingWisp(level, vec3);
                world.m_7967_((Entity)wisp);
                if (x == n) break;
                ++x;
            }
        }
        MindflayRegistry.INSTANCE.performBrainsweeps(input.getInputs(), input.getEnv().getCaster());
        return new MindflayResult(true);
    }
}

