/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import org.apache.commons.lang3.tuple.Pair;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.mutil.util.RotationHelper;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.client.particle.SweepingStrikeParticleOption;
import se.mickelus.tetra.effect.CritEffect;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.JankEffect;
import se.mickelus.tetra.effect.ReachingEffect;
import se.mickelus.tetra.effect.SculkTaintEffect;
import se.mickelus.tetra.effect.StrikingEffect;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.ToolActionHelper;

@ParametersAreNonnullByDefault
public class SweepingStrikeEffect {
    private static final Cache<UUID, Integer> strikeCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.MINUTES).build();

    private static int getStrikeCounter(UUID entityId) {
        int counter = 0;
        try {
            counter = (Integer)strikeCache.get((Object)entityId, () -> 0);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        strikeCache.put((Object)entityId, (Object)(counter + 1));
        return counter;
    }

    public static void causeTruesweepEffect(Player player, ItemStack itemStack) {
        StrikingEffect.effectActionMap.stream().filter(entry -> EffectHelper.getEffectLevel(itemStack, (ItemEffect)entry.getLeft()) > 0).map(Pair::getRight).findFirst().ifPresent(tool -> {
            double lookDistance = Optional.ofNullable(player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get())).map(AttributeInstance::m_22135_).orElse(4.5);
            BlockPos origin = BlockPos.m_274446_((Position)player.m_146892_().m_82549_(player.m_20252_(0.0f).m_82490_(lookDistance)));
            SweepingStrikeEffect.causeEffect(player.m_9236_(), player, itemStack, origin, tool);
        });
    }

    public static void causeEffect(Level world, Player breakingPlayer, ItemStack toolStack, BlockPos origin, ToolAction tool) {
        if (world.f_46443_) {
            return;
        }
        boolean alternate = SweepingStrikeEffect.isAlternate(breakingPlayer);
        List<Pair<Integer, BlockPos>> targets = SweepingStrikeEffect.breakBlocksAround(world, breakingPlayer, toolStack, origin, tool, alternate);
        int minDelay = targets.stream().mapToInt(Pair::getLeft).min().orElse(0);
        int maxDelay = targets.stream().mapToInt(Pair::getLeft).max().orElse(0);
        int duration = maxDelay - minDelay;
        duration = targets.size() > 10 ? duration : duration * 2;
        duration = Math.max(4, duration);
        double distance = breakingPlayer.m_146892_().m_82546_(Vec3.m_82512_((Vec3i)origin)).m_82553_();
        SweepingStrikeEffect.causeVfx(breakingPlayer, alternate, duration, (float)distance - 0.5f);
        Item item = toolStack.m_41720_();
        if (item instanceof ItemModularHandheld) {
            ItemModularHandheld item2 = (ItemModularHandheld)item;
            int amount = Math.max(1, targets.size() / 4);
            if (!targets.isEmpty()) {
                item2.applyUsageEffects((LivingEntity)breakingPlayer, toolStack, amount);
            }
            item2.applyDamage(amount, toolStack, (LivingEntity)breakingPlayer);
        }
    }

    private static void causeVfx(Player player, boolean isAlternate, int duration, float distance) {
        if (player.m_9236_() instanceof ServerLevel) {
            Vec3 viewVec = player.m_20252_(0.0f).m_82490_((double)distance);
            float ox = -Mth.m_14031_((float)(player.m_146908_() * (float)Math.PI / 180.0f)) * 0.5f;
            float oz = Mth.m_14089_((float)(player.m_146908_() * (float)Math.PI / 180.0f)) * 0.5f;
            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)new SweepingStrikeParticleOption(duration, isAlternate, player.m_146909_(), player.m_146908_()), player.m_20185_() + viewVec.f_82479_ + (double)ox, player.m_20227_(0.6) + viewVec.f_82480_, player.m_20189_() + viewVec.f_82481_ + (double)oz, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static List<Pair<Integer, BlockPos>> breakBlocksAround(Level world, Player breakingPlayer, ItemStack toolStack, BlockPos originPos, ToolAction tool, boolean alternate) {
        int vertical;
        if (world.f_46443_) {
            return Collections.emptyList();
        }
        Vec3 playerPosition = breakingPlayer.m_146892_();
        int playerDistance = Mth.m_14165_((double)playerPosition.m_82554_(Vec3.m_82512_((Vec3i)originPos)));
        Direction facing = breakingPlayer.m_6350_();
        double efficiency = CastOptional.cast((Object)toolStack.m_41720_(), ItemModularHandheld.class).map(item -> Float.valueOf(item.getToolEfficiency(toolStack, tool))).map(eff -> Float.valueOf(EffectHelper.getModifiedEfficiency(breakingPlayer, toolStack, eff.floatValue(), null, null))).orElse(Float.valueOf(0.0f)).floatValue();
        double critMultiplier = CastOptional.cast((Object)toolStack.m_41720_(), ItemModularHandheld.class).map(item -> CritEffect.rollMultiplier(breakingPlayer.m_217043_(), item, toolStack)).orElse(1.0);
        if (critMultiplier != 1.0) {
            efficiency *= critMultiplier;
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123808_, (double)((float)originPos.m_123341_() + 0.5f), (double)((float)originPos.m_123342_() + 0.5f), (double)((float)originPos.m_123343_() + 0.5f), 15, 0.2, 0.2, 0.2, 0.0);
        }
        int jankLevel = EffectHelper.getEffectLevel(toolStack, ItemEffect.janking);
        int skulkTaintLevel = EffectHelper.getEffectLevel(toolStack, ItemEffect.sculkTaint);
        int reachingLevel = EffectHelper.getEffectLevel(toolStack, ItemEffect.reaching);
        float reachingEfficiency = EffectHelper.getEffectEfficiency(toolStack, ItemEffect.reaching);
        float focusLevel = EffectHelper.getEffectEfficiency(toolStack, ItemEffect.sweepingFocus);
        boolean planarSweep = EffectHelper.getEffectLevel(toolStack, ItemEffect.planarSweep) > 0;
        float focus = focusLevel > 0.0f ? focusLevel - 1.0f : 0.0f;
        int n = vertical = planarSweep ? 0 : 1;
        float pitch = planarSweep ? (Math.abs(breakingPlayer.m_146909_()) > 45.0f ? -1.5707964f * Math.signum(breakingPlayer.m_146909_()) : 0.0f) : breakingPlayer.m_146909_() / -180.0f * (float)Math.PI;
        boolean tryReplant = EffectHelper.tryReplant(toolStack, tool);
        List<BlockPos> positions = BlockPos.m_121886_((int)-16, (int)(-vertical), (int)(-playerDistance - 1), (int)16, (int)vertical, (int)32).map(BlockPos::new).sorted(Comparator.comparingInt(pos -> SweepingStrikeEffect.getPosWeight(pos, focus, playerDistance))).toList();
        ArrayList<Pair<Integer, BlockPos>> targets = new ArrayList<Pair<Integer, BlockPos>>();
        for (BlockPos pos2 : positions) {
            BlockPos worldPos = Optional.of(pos2).map(p -> RotationHelper.rotatePitch((BlockPos)p, (float)pitch)).map(p -> RotationHelper.rotateDirection((BlockPos)p, (Direction)facing)).map(arg_0 -> ((BlockPos)originPos).m_121955_(arg_0)).get();
            BlockState blockState = world.m_8055_(worldPos);
            float blockHardness = blockState.m_60800_((BlockGetter)world, worldPos);
            if (ToolActionHelper.isEffectiveOn(tool, blockState) && blockHardness >= 0.0f && (!tryReplant || SweepingStrikeEffect.isFullyGrown(blockState))) {
                if (!ToolActionHelper.playerCanDestroyBlock(breakingPlayer, blockState, worldPos, toolStack, tool)) break;
                double reachingFactor = SweepingStrikeEffect.getReachingFactor(playerPosition, worldPos, reachingLevel, reachingEfficiency);
                if ((efficiency -= Math.max(0.5, (double)blockHardness / reachingFactor + (double)(Math.abs(pos2.m_123341_()) + Math.abs(pos2.m_123343_())) * 0.05)) >= 0.0) {
                    targets.add((Pair<Integer, BlockPos>)Pair.of((Object)(alternate ? -pos2.m_123341_() : pos2.m_123341_()), (Object)worldPos));
                }
            } else if (!blockState.m_60795_() && !blockState.m_278721_()) {
                efficiency -= Math.max((double)Math.abs(blockHardness), 0.5);
            }
            if (!(efficiency <= 0.0)) continue;
            break;
        }
        int minDelay = targets.stream().mapToInt(Pair::getLeft).min().orElse(0);
        targets.forEach(pair -> {
            BlockPos pos = (BlockPos)pair.getRight();
            int delay = (Integer)pair.getLeft() - minDelay;
            delay = targets.size() > 10 ? delay : delay * 2;
            BlockState blockState = world.m_8055_(pos);
            SweepingStrikeEffect.enqueueBlockBreak(world, breakingPlayer, toolStack, pos, blockState, delay, tryReplant, jankLevel, skulkTaintLevel);
        });
        return targets;
    }

    private static double getReachingFactor(Vec3 playerPos, BlockPos blockPos, int reachingLevel, float reachingEfficiency) {
        return reachingLevel > 0 ? (double)ReachingEffect.getMultiplier(reachingLevel, blockPos.m_203193_((Position)playerPos), reachingEfficiency) : 1.0;
    }

    private static int getPosWeight(BlockPos pos, float focus, int backDist) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        double res = Math.pow(Math.abs(x), 2.2) * 1.5 * (double)(1.0f - focus) + Math.pow(Math.abs(y) * 4, 2.0) + Math.pow(z, 2.0) * (double)(1.0f + focus);
        if (x < 0) {
            res += (double)(-x);
        }
        if (z < 0) {
            res += Math.pow(Math.abs(x), 2.2) * (double)(1.0f - focus) + Math.pow(Math.abs(y) * 4, 2.0) * 1.5 + Math.pow((float)z * 12.0f / (float)backDist, 2.0) * 2.0 * (double)(1.0f + focus);
        }
        return (int)res;
    }

    private static boolean isAlternate(Player player) {
        return SweepingStrikeEffect.getStrikeCounter(player.m_20148_()) % 2 == 0;
    }

    private static void enqueueBlockBreak(Level world, Player player, ItemStack itemStack, BlockPos pos, BlockState blockState, int delay, boolean tryReplant, int jankLevel, int skulkTaintLevel) {
        if (delay > 0) {
            ServerScheduler.schedule(delay, () -> SweepingStrikeEffect.breakBlock(world, player, itemStack, pos, blockState, tryReplant, jankLevel, skulkTaintLevel));
        } else {
            SweepingStrikeEffect.breakBlock(world, player, itemStack, pos, blockState, tryReplant, jankLevel, skulkTaintLevel);
        }
    }

    private static void breakBlock(Level world, Player player, ItemStack itemStack, BlockPos pos, BlockState blockState, boolean tryReplant, int jankLevel, int skulkTaintLevel) {
        if (EffectHelper.breakBlock(world, player, itemStack, pos, blockState, true, tryReplant)) {
            EffectHelper.sendEventToPlayer((ServerPlayer)player, 2001, pos, Block.m_49956_((BlockState)blockState));
            if (jankLevel > 0) {
                JankEffect.jankItemsDelayed((ServerLevel)world, pos, jankLevel, EffectHelper.getEffectEfficiency(itemStack, ItemEffect.janking), (Entity)player);
            }
            if (skulkTaintLevel > 0) {
                SculkTaintEffect.perform((ServerLevel)world, pos, skulkTaintLevel, EffectHelper.getEffectEfficiency(itemStack, ItemEffect.sculkTaint));
            }
        }
    }

    private static boolean isFullyGrown(BlockState blockState) {
        CropBlock crop;
        Block block = blockState.m_60734_();
        return block instanceof CropBlock && (crop = (CropBlock)block).m_52307_(blockState);
    }

    private static void debugPlacement(Level world, BlockPos origin, List<BlockPos> positions, int count) {
        for (int i = 0; i < positions.size() && i < count; ++i) {
            BlockPos pos = positions.get(i);
            if ((float)i > (float)count * 7.0f / 8.0f) {
                SweepingStrikeEffect.enqueueDebugPlacement(world, pos, Blocks.f_50147_.m_49966_(), i * 5 + 100);
                continue;
            }
            if ((float)i > (float)count * 6.0f / 8.0f) {
                SweepingStrikeEffect.enqueueDebugPlacement(world, pos, Blocks.f_50203_.m_49966_(), i * 5 + 100);
                continue;
            }
            if ((float)i > (float)count * 5.0f / 8.0f) {
                SweepingStrikeEffect.enqueueDebugPlacement(world, pos, Blocks.f_50211_.m_49966_(), i * 5 + 100);
                continue;
            }
            if ((float)i > (float)count * 4.0f / 8.0f) {
                SweepingStrikeEffect.enqueueDebugPlacement(world, pos, Blocks.f_50209_.m_49966_(), i * 5 + 100);
                continue;
            }
            if ((float)i > (float)count * 3.0f / 8.0f) {
                SweepingStrikeEffect.enqueueDebugPlacement(world, pos, Blocks.f_50205_.m_49966_(), i * 5 + 100);
                continue;
            }
            if ((float)i > (float)count * 2.0f / 8.0f) {
                SweepingStrikeEffect.enqueueDebugPlacement(world, pos, Blocks.f_50204_.m_49966_(), i * 5 + 100);
                continue;
            }
            if ((float)i > (float)count * 1.0f / 8.0f) {
                SweepingStrikeEffect.enqueueDebugPlacement(world, pos, Blocks.f_50148_.m_49966_(), i * 5 + 100);
                continue;
            }
            SweepingStrikeEffect.enqueueDebugPlacement(world, pos, Blocks.f_50214_.m_49966_(), i * 5 + 100);
        }
    }

    private static void enqueueDebugPlacement(Level world, BlockPos pos, BlockState blockState, int delay) {
        ServerScheduler.schedule(delay, () -> world.m_7731_(pos, blockState, 3));
    }
}

