/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.suspend;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.phys.Vec3;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.suspend.SuspendPotionEffect;

@ParametersAreNonnullByDefault
public class SuspendEffect {
    private static final Set<MobEffect> enablingEffects = Stream.concat(Arrays.stream(BeaconBlockEntity.f_58646_).flatMap(Arrays::stream), Stream.of(MobEffects.f_19592_)).collect(Collectors.toSet());

    public static void toggleSuspend(Player entity, boolean toggleOn) {
        if (toggleOn) {
            if (SuspendEffect.canSuspend(entity)) {
                Vec3 motion = entity.m_20184_();
                entity.m_20334_(motion.f_82479_, 0.0, motion.f_82481_);
                entity.f_19864_ = true;
                entity.m_7292_(new MobEffectInstance((MobEffect)SuspendPotionEffect.instance, 100, 0, false, false));
            }
        } else {
            entity.m_21195_((MobEffect)SuspendPotionEffect.instance);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canSuspend(Player entity) {
        ItemStack itemStack = ToolbeltHelper.findToolbelt(entity);
        if (itemStack.m_41619_()) return false;
        if (((IModularItem)itemStack.m_41720_()).getEffectLevel(itemStack, ItemEffect.suspendSelf) <= 0) return false;
        boolean bl = true;
        boolean hasEffect = bl;
        if (!hasEffect) return false;
        if (!entity.m_21220_().stream().filter(MobEffectInstance::m_19571_).map(MobEffectInstance::m_19544_).anyMatch(enablingEffects::contains)) return false;
        return true;
    }
}

