/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.davidqf555.minecraft.beams.common.entities.BeamEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class BeamRenderer<T extends BeamEntity>
extends EntityRenderer<T> {
    public BeamRenderer(EntityRendererProvider.Context manager) {
        super(manager);
    }

    public void render(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Vec3 dif = ((BeamEntity)((Object)entityIn)).getEnd().m_82546_(entityIn.m_20182_());
        double length = dif.m_82553_();
        float yaw = (float)(1.5707963267948966 - Mth.m_14136_((double)(-dif.m_7094_()), (double)dif.m_7096_()));
        float pitch = (float)Math.asin(Mth.m_14008_((double)(dif.m_7098_() / length), (double)-1.0, (double)1.0));
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252392_.m_252961_(yaw));
        matrixStackIn.m_252781_(Axis.f_252529_.m_252961_(pitch));
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110502_());
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_252922_();
        int color = ((BeamEntity)((Object)entityIn)).getColor();
        float alpha = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        int layers = ((BeamEntity)((Object)entityIn)).getLayers();
        float startWidthRadius = (float)(((BeamEntity)((Object)entityIn)).getStartWidth() / 2.0);
        float startHeightRadius = (float)(((BeamEntity)((Object)entityIn)).getStartHeight() / 2.0);
        float endWidthRadius = (float)(((BeamEntity)((Object)entityIn)).getEndWidth() / 2.0);
        float endHeightRadius = (float)(((BeamEntity)((Object)entityIn)).getEndHeight() / 2.0);
        for (int i = 1; i <= layers; ++i) {
            float sWidthRadius = startWidthRadius * (float)i / (float)layers;
            float sHeightRadius = startHeightRadius * (float)i / (float)layers;
            float eWidthRadius = endWidthRadius * (float)i / (float)layers;
            float eHeightRadius = endHeightRadius * (float)i / (float)layers;
            builder.m_252986_(matrix4f, -sWidthRadius, -sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -eWidthRadius, -eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, 0.0f + eWidthRadius, -eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, sWidthRadius, -sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, sWidthRadius, -sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, 0.0f + eWidthRadius, -eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -eWidthRadius, -eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -sWidthRadius, -sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, sWidthRadius, -sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, 0.0f + eWidthRadius, -eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, 0.0f + eWidthRadius, 0.0f + eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, sWidthRadius, sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, sWidthRadius, sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, 0.0f + eWidthRadius, 0.0f + eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, 0.0f + eWidthRadius, -eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, sWidthRadius, -sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, sWidthRadius, sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, 0.0f + eWidthRadius, 0.0f + eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -eWidthRadius, 0.0f + eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -sWidthRadius, sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -sWidthRadius, sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -eWidthRadius, 0.0f + eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, 0.0f + eWidthRadius, 0.0f + eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, sWidthRadius, sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -sWidthRadius, sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -eWidthRadius, 0.0f + eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -eWidthRadius, -eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -sWidthRadius, -sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -sWidthRadius, -sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -eWidthRadius, -eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -eWidthRadius, 0.0f + eHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
            builder.m_252986_(matrix4f, -sWidthRadius, sHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        }
        builder.m_252986_(matrix4f, -startWidthRadius, -startHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, -startWidthRadius, startHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, startWidthRadius, startHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, startWidthRadius, -startHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, startWidthRadius, -startHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, startWidthRadius, startHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, -startWidthRadius, startHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, -startWidthRadius, -startHeightRadius, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, -endWidthRadius, -endHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, -endWidthRadius, endHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, endWidthRadius, endHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, endWidthRadius, -endHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, endWidthRadius, -endHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, endWidthRadius, endHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, -endWidthRadius, endHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, -endWidthRadius, -endHeightRadius, (float)(-length)).m_85950_(red, green, blue, alpha).m_5752_();
        matrixStackIn.m_85849_();
    }

    protected int getBlockLightLevel(T entity, BlockPos pos) {
        return 15;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return null;
    }
}

