/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.client;

import io.github.davidqf555.minecraft.beams.client.BeamRenderer;
import io.github.davidqf555.minecraft.beams.client.OmnidirectionalMirrorModel;
import io.github.davidqf555.minecraft.beams.client.OmnidirectionalMirrorTileEntityRenderer;
import io.github.davidqf555.minecraft.beams.client.OmnidirectionalProjectorModel;
import io.github.davidqf555.minecraft.beams.client.OmnidirectionalProjectorTileEntityRenderer;
import io.github.davidqf555.minecraft.beams.client.SimpleContainerScreen;
import io.github.davidqf555.minecraft.beams.client.SimpleItemColor;
import io.github.davidqf555.minecraft.beams.common.items.ProjectorContainer;
import io.github.davidqf555.minecraft.beams.common.items.TurretContainer;
import io.github.davidqf555.minecraft.beams.registration.ContainerRegistry;
import io.github.davidqf555.minecraft.beams.registration.EntityRegistry;
import io.github.davidqf555.minecraft.beams.registration.ItemRegistry;
import io.github.davidqf555.minecraft.beams.registration.TileEntityRegistry;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="beams", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ClientRegistry {
    public static final ModelLayerLocation OMNIDIRECTIONAL_PROJECTOR = new ModelLayerLocation(new ResourceLocation("beams", "omnidirectional_projector"), "projector");
    public static final ModelLayerLocation OMNIDIRECTIONAL_MIRROR = new ModelLayerLocation(new ResourceLocation("beams", "omnidirectional_mirror"), "mirror");
    private static final ResourceLocation HOPPER = new ResourceLocation("textures/gui/container/hopper.png");
    private static final ResourceLocation TURRET_MENU = new ResourceLocation("beams", "textures/gui/container/turret.png");
    private static final ResourceLocation PROJECTOR = new ResourceLocation("beams", "textures/block/omnidirectional_projector.png");
    private static final ResourceLocation TURRET = new ResourceLocation("beams", "textures/block/turret.png");

    private ClientRegistry() {
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityRegistry.BEAM.get(), BeamRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TileEntityRegistry.OMNIDIRECTIONAL_BEAM_PROJECTOR.get(), context -> new OmnidirectionalProjectorTileEntityRenderer(context, PROJECTOR));
        event.registerBlockEntityRenderer((BlockEntityType)TileEntityRegistry.OMNIDIRECTIONAL_MIRROR.get(), OmnidirectionalMirrorTileEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TileEntityRegistry.TURRET.get(), context -> new OmnidirectionalProjectorTileEntityRenderer(context, TURRET));
    }

    @SubscribeEvent
    public static void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(OMNIDIRECTIONAL_PROJECTOR, OmnidirectionalProjectorModel::createLayerDefinition);
        event.registerLayerDefinition(OMNIDIRECTIONAL_MIRROR, OmnidirectionalMirrorModel::createLayerDefinition);
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)ContainerRegistry.PROJECTOR.get()), (container, player, name) -> new SimpleContainerScreen<ProjectorContainer>(HOPPER, (ProjectorContainer)container, player, name));
            MenuScreens.m_96206_((MenuType)((MenuType)ContainerRegistry.TURRET.get()), (container, player, name) -> new SimpleContainerScreen<TurretContainer>(TURRET_MENU, (TurretContainer)container, player, name));
        });
    }

    @SubscribeEvent
    public static void onItemColorHandler(RegisterColorHandlersEvent.Item event) {
        ItemColors colors = event.getItemColors();
        for (DyeColor dye : ItemRegistry.COLOR_MODULES.keySet()) {
            float[] diffuse = dye.m_41068_();
            int color = FastColor.ARGB32.m_13660_((int)255, (int)((int)(diffuse[0] * 255.0f)), (int)((int)(diffuse[1] * 255.0f)), (int)((int)(diffuse[2] * 255.0f)));
            ItemLike[] itemLikeArray = new ItemLike[1];
            itemLikeArray[0] = () -> ItemRegistry.COLOR_MODULES.get(dye).get();
            colors.m_92689_((ItemColor)new SimpleItemColor((stack, layer) -> {
                if (layer == 1) {
                    return color;
                }
                return -1;
            }), itemLikeArray);
        }
    }
}

