/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.blocks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.davidqf555.minecraft.beams.common.ServerConfigs;
import io.github.davidqf555.minecraft.beams.common.blocks.AbstractProjectorBlock;
import io.github.davidqf555.minecraft.beams.common.entities.BeamEntity;
import io.github.davidqf555.minecraft.beams.common.modules.ProjectorModuleType;
import io.github.davidqf555.minecraft.beams.registration.EntityRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class DirectedProjectorBlock
extends AbstractProjectorBlock {
    protected DirectedProjectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract Vec3 getStartOffset(Level var1, BlockPos var2, BlockState var3);

    public abstract Vec3 getBeamDirection(Level var1, BlockPos var2, BlockState var3);

    @Override
    public List<BeamEntity> shoot(Level world, BlockPos pos, BlockState state) {
        Vec3 dir = this.getBeamDirection(world, pos, state);
        Vec3 start = Vec3.m_82528_((Vec3i)pos).m_82549_(this.getStartOffset(world, pos, state));
        double size = (Double)ServerConfigs.INSTANCE.defaultBeamSize.get();
        Object beam = BeamEntity.shoot((EntityType)EntityRegistry.BEAM.get(), world, start, dir, (Double)ServerConfigs.INSTANCE.projectorMaxRange.get(), this.getModules(world, pos, state), size, size, null, pos);
        if (beam == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of(beam);
    }

    protected Map<ProjectorModuleType, Integer> getModules(Level world, BlockPos pos, BlockState state) {
        return ImmutableMap.of();
    }
}

