/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.blocks;

import io.github.davidqf555.minecraft.beams.common.blocks.AbstractMirrorBlock;
import io.github.davidqf555.minecraft.beams.common.blocks.IPointable;
import io.github.davidqf555.minecraft.beams.common.blocks.te.AbstractProjectorTileEntity;
import io.github.davidqf555.minecraft.beams.common.blocks.te.PointableRedirectorTileEntity;
import io.github.davidqf555.minecraft.beams.common.blocks.te.RedirectorTileEntity;
import io.github.davidqf555.minecraft.beams.registration.TileEntityRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OmnidirectionalMirrorBlock
extends AbstractMirrorBlock
implements IPointable {
    private static final VoxelShape VISUAL = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public OmnidirectionalMirrorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return OmnidirectionalMirrorBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TileEntityRegistry.OMNIDIRECTIONAL_MIRROR.get()), AbstractProjectorTileEntity::tick);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return VISUAL;
    }

    @Override
    protected Vec3 getFaceNormal(Level world, BlockPos pos, BlockState state) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PointableRedirectorTileEntity) {
            return ((PointableRedirectorTileEntity)te).getNormal();
        }
        return new Vec3(1.0, 0.0, 0.0);
    }

    @Override
    public RedirectorTileEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PointableRedirectorTileEntity(pos, state);
    }

    @Override
    @Nullable
    public UUID getConnectionID(Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PointableRedirectorTileEntity) {
            return ((PointableRedirectorTileEntity)te).getUUID();
        }
        return null;
    }

    @Override
    public void onPoint(Level world, BlockPos pos, Vec3 target) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PointableRedirectorTileEntity) {
            Vec3 dir = target.m_82546_(Vec3.m_82512_((Vec3i)pos)).m_82541_();
            ((PointableRedirectorTileEntity)te).setNormal(dir);
            this.updateBeams(world, pos);
            te.m_6596_();
        }
    }
}

