/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.blocks;

import io.github.davidqf555.minecraft.beams.common.blocks.AbstractMirrorBlock;
import io.github.davidqf555.minecraft.beams.common.blocks.te.AbstractProjectorTileEntity;
import io.github.davidqf555.minecraft.beams.registration.TileEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SimpleMirrorBlock
extends AbstractMirrorBlock {
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape TOP_SLAB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOT_SLAB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape OCTET_TOP_PP = Block.m_49796_((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape OCTET_TOP_PN = Block.m_49796_((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape OCTET_TOP_NP = Block.m_49796_((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape OCTET_TOP_NN = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    private static final VoxelShape OCTET_BOT_PP = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape OCTET_BOT_PN = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    private static final VoxelShape OCTET_BOT_NP = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    private static final VoxelShape OCTET_BOT_NN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    private static final VoxelShape TOP_PX = Shapes.m_83124_((VoxelShape)TOP_SLAB, (VoxelShape[])new VoxelShape[]{OCTET_BOT_PP, OCTET_BOT_PN});
    private static final VoxelShape TOP_NX = Shapes.m_83124_((VoxelShape)TOP_SLAB, (VoxelShape[])new VoxelShape[]{OCTET_BOT_NN, OCTET_BOT_NP});
    private static final VoxelShape BOT_PX = Shapes.m_83124_((VoxelShape)BOT_SLAB, (VoxelShape[])new VoxelShape[]{OCTET_TOP_PP, OCTET_TOP_PN});
    private static final VoxelShape BOT_NX = Shapes.m_83124_((VoxelShape)BOT_SLAB, (VoxelShape[])new VoxelShape[]{OCTET_TOP_NN, OCTET_TOP_NP});
    private static final VoxelShape TOP_PZ = Shapes.m_83124_((VoxelShape)TOP_SLAB, (VoxelShape[])new VoxelShape[]{OCTET_BOT_PP, OCTET_BOT_NP});
    private static final VoxelShape TOP_NZ = Shapes.m_83124_((VoxelShape)TOP_SLAB, (VoxelShape[])new VoxelShape[]{OCTET_BOT_NN, OCTET_BOT_PN});
    private static final VoxelShape BOT_PZ = Shapes.m_83124_((VoxelShape)BOT_SLAB, (VoxelShape[])new VoxelShape[]{OCTET_TOP_PP, OCTET_TOP_NP});
    private static final VoxelShape BOT_NZ = Shapes.m_83124_((VoxelShape)BOT_SLAB, (VoxelShape[])new VoxelShape[]{OCTET_TOP_NN, OCTET_TOP_PN});

    public SimpleMirrorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return SimpleMirrorBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TileEntityRegistry.MIRROR.get()), AbstractProjectorTileEntity::tick);
    }

    public Face getFace(BlockState state) {
        Half half = (Half)state.m_61143_(HALF);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        switch (facing) {
            case EAST: {
                if (half == Half.TOP) {
                    return Face.DXN;
                }
                return Face.UXN;
            }
            case WEST: {
                if (half == Half.TOP) {
                    return Face.DXP;
                }
                return Face.UXP;
            }
            case SOUTH: {
                if (half == Half.TOP) {
                    return Face.DZN;
                }
                return Face.UZN;
            }
        }
        if (half == Half.TOP) {
            return Face.DZP;
        }
        return Face.UZP;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        Half half = (Half)state.m_61143_(HALF);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        switch (facing) {
            case EAST: {
                if (half == Half.TOP) {
                    return TOP_PX;
                }
                return BOT_PX;
            }
            case WEST: {
                if (half == Half.TOP) {
                    return TOP_NX;
                }
                return BOT_NX;
            }
            case SOUTH: {
                if (half == Half.TOP) {
                    return TOP_PZ;
                }
                return BOT_PZ;
            }
        }
        if (half == Half.TOP) {
            return TOP_NZ;
        }
        return BOT_NZ;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF, FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState prev = super.m_5573_(context);
        if (prev == null) {
            return null;
        }
        Direction dir = context.m_43719_();
        BlockPos pos = context.m_8083_();
        return (BlockState)((BlockState)prev.m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HALF, (Comparable)(dir != Direction.DOWN && (dir == Direction.UP || context.m_43720_().f_82480_ - (double)pos.m_123342_() <= 0.5) ? Half.BOTTOM : Half.TOP));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType path) {
        return false;
    }

    @Override
    protected Vec3 getFaceNormal(Level world, BlockPos pos, BlockState state) {
        return this.getFace(state).getNormal();
    }

    public static enum Face {
        UXP(new Vec3(1.0, 1.0, 0.0).m_82541_()),
        UXN(new Vec3(-1.0, 1.0, 0.0).m_82541_()),
        DXP(new Vec3(1.0, -1.0, 0.0).m_82541_()),
        DXN(new Vec3(-1.0, -1.0, 0.0).m_82541_()),
        UZP(new Vec3(0.0, 1.0, 1.0).m_82541_()),
        UZN(new Vec3(0.0, 1.0, -1.0).m_82541_()),
        DZP(new Vec3(0.0, -1.0, 1.0).m_82541_()),
        DZN(new Vec3(0.0, -1.0, -1.0).m_82541_());

        private final Vec3 normal;

        private Face(Vec3 normal) {
            this.normal = normal;
        }

        public Vec3 getNormal() {
            return this.normal;
        }
    }
}

