/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.blocks.te;

import io.github.davidqf555.minecraft.beams.common.blocks.te.AbstractProjectorTileEntity;
import io.github.davidqf555.minecraft.beams.common.items.ProjectorContainer;
import io.github.davidqf555.minecraft.beams.common.items.ProjectorInventory;
import io.github.davidqf555.minecraft.beams.common.modules.ProjectorModuleType;
import io.github.davidqf555.minecraft.beams.registration.TileEntityRegistry;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ContainerProjectorTileEntity
extends AbstractProjectorTileEntity
implements Container,
MenuProvider,
Nameable {
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private Component name;

    public ContainerProjectorTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ContainerProjectorTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TileEntityRegistry.BEAM_PROJECTOR.get(), pos, state);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack m_7407_(int index, int amount) {
        ItemStack stack = ContainerHelper.m_18969_(this.items, (int)index, (int)amount);
        if (!stack.m_41619_()) {
            this.markChanged();
            this.m_6596_();
        }
        return stack;
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.setItemNoUpdate(index, stack);
        this.markChanged();
        this.m_6596_();
    }

    protected void setItemNoUpdate(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        return this.m_58904_().m_7702_(this.m_58899_()) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        this.items.clear();
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        Component custom = this.m_7770_();
        if (custom != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)custom));
        }
        ListTag items = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            items.add((Object)this.m_8020_(i).m_41739_(new CompoundTag()));
        }
        tag.m_128365_("Items", (Tag)items);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("CustomName", 8)) {
            this.setCustomName((Component)Component.Serializer.m_130701_((String)tag.m_128461_("CustomName")));
        }
        if (tag.m_128425_("Items", 9)) {
            ListTag list = tag.m_128437_("Items", 10);
            for (int i = 0; i < Math.min(tag.m_128440_(), this.m_6643_()); ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                this.setItemNoUpdate(i, stack);
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ProjectorContainer(id, inventory, this);
    }

    public Component m_7755_() {
        Component custom = this.m_7770_();
        return custom == null ? this.getDefaultName() : custom;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)Util.m_137492_((String)"container", (ResourceLocation)new ResourceLocation("beams", "projector")));
    }

    public int m_6893_() {
        return 1;
    }

    public Map<ProjectorModuleType, Integer> getModules() {
        return ProjectorInventory.getModuleTypes(this);
    }
}

