/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.entities;

import io.github.davidqf555.minecraft.beams.common.blocks.IBeamAffectEffect;
import io.github.davidqf555.minecraft.beams.common.blocks.IBeamCollisionEffect;
import io.github.davidqf555.minecraft.beams.common.blocks.te.AbstractProjectorTileEntity;
import io.github.davidqf555.minecraft.beams.common.entities.Cuboid;
import io.github.davidqf555.minecraft.beams.common.entities.DoubleSerializer;
import io.github.davidqf555.minecraft.beams.common.modules.ProjectorModuleType;
import io.github.davidqf555.minecraft.beams.registration.ProjectorModuleRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.registries.IForgeRegistry;

public class BeamEntity
extends Entity {
    public static final double POKE = 0.1;
    private static final EntityDataAccessor<Double> X = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)DoubleSerializer.INSTANCE);
    private static final EntityDataAccessor<Double> Y = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)DoubleSerializer.INSTANCE);
    private static final EntityDataAccessor<Double> Z = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)DoubleSerializer.INSTANCE);
    private static final EntityDataAccessor<Double> END_WIDTH = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)DoubleSerializer.INSTANCE);
    private static final EntityDataAccessor<Double> END_HEIGHT = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)DoubleSerializer.INSTANCE);
    private static final EntityDataAccessor<Double> START_WIDTH = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)DoubleSerializer.INSTANCE);
    private static final EntityDataAccessor<Double> START_HEIGHT = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)DoubleSerializer.INSTANCE);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LAYERS = SynchedEntityData.m_135353_(BeamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final Map<ProjectorModuleType, Integer> modules = new HashMap<ProjectorModuleType, Integer>();
    private BlockPos projector;
    private double maxRange;
    private UUID shooter;
    private UUID parent;
    private int lifespan;
    private Cuboid shape;

    public BeamEntity(EntityType<? extends BeamEntity> type, Level world) {
        super(type, world);
    }

    @Nullable
    public static <T extends BeamEntity> T shoot(EntityType<T> type, Level world, Vec3 start, Vec3 dir, double range, Map<ProjectorModuleType, Integer> modules, double baseWidth, double baseHeight, @Nullable UUID parent, @Nullable BlockPos projector) {
        BeamEntity beam = (BeamEntity)type.m_20615_(world);
        if (beam != null) {
            beam.setDirectParent(parent);
            Vec3 end = world.m_45547_(new ClipContext(start, start.m_82549_(dir.m_82490_(range)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null)).m_82450_().m_82549_(dir.m_82490_(0.1));
            double startFactor = BeamEntity.getStartSizeFactor(modules);
            double startWidth = baseWidth * startFactor;
            double startHeight = baseHeight * startFactor;
            beam.m_6034_(start.m_7096_(), start.m_7098_(), start.m_7094_());
            beam.setEnd(end, true, false);
            beam.setModules(modules);
            beam.setStartWidth(startWidth);
            beam.setStartHeight(startHeight);
            double growthRate = BeamEntity.getGrowthRate(modules);
            double length = end.m_82546_(start).m_82553_();
            beam.setEndWidth(startWidth + growthRate * length);
            beam.setEndHeight(startHeight + growthRate * length);
            beam.setMaxRange(range);
            beam.setProjectorPos(projector);
            beam.initializeModules();
            world.m_7967_((Entity)beam);
            return (T)((Object)beam);
        }
        return null;
    }

    private static double getGrowthRate(Map<ProjectorModuleType, Integer> modules) {
        double rate = 0.0;
        for (ProjectorModuleType type : modules.keySet()) {
            rate += type.getGrowthRate(modules.get(type));
        }
        return rate;
    }

    private static double getStartSizeFactor(Map<ProjectorModuleType, Integer> modules) {
        double factor = 1.0;
        for (ProjectorModuleType type : modules.keySet()) {
            factor *= type.getStartSizeFactor(modules.get(type));
        }
        return factor;
    }

    public double getMaxRange() {
        return this.maxRange;
    }

    public void setMaxRange(double maxRange) {
        this.maxRange = maxRange;
    }

    protected boolean isSignificantlyDifferent(Vec3 v1, Vec3 v2) {
        return v1.m_82557_(v2) >= 1.0E-5;
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            BlockPos endPos;
            BlockState endState;
            Block endBlock;
            Vec3 dir;
            BlockHitResult trace;
            Vec3 end;
            BlockPos projector = this.getProjectorPos();
            int lifespan = this.getLifespan();
            if (lifespan > 0) {
                if (this.f_19797_ >= lifespan) {
                    this.m_146870_();
                    return;
                }
            } else {
                if (projector == null) {
                    this.m_146870_();
                    return;
                }
                BlockEntity te = level.m_7702_(projector);
                if (!(te instanceof AbstractProjectorTileEntity) || !((AbstractProjectorTileEntity)te).getBeams().contains(this.m_20148_())) {
                    this.m_146870_();
                    return;
                }
            }
            Vec3 start = this.m_20182_();
            Vec3 original = this.getEnd();
            if (this.isSignificantlyDifferent(original, end = (trace = level.m_45547_(new ClipContext(start, start.m_82549_((dir = original.m_82546_(start).m_82541_()).m_82490_(this.maxRange)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null))).m_82450_().m_82549_(dir.m_82490_(0.1)))) {
                this.setEnd(end, true, true);
                original = end;
            }
            if ((endBlock = (endState = level.m_8055_(endPos = BlockPos.m_274446_((Position)original))).m_60734_()) instanceof IBeamCollisionEffect) {
                ((IBeamCollisionEffect)endBlock).onBeamCollisionTick(this, endPos, endState);
            }
            Cuboid shape = this.getShape();
            Set blockModules = this.modules.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0 && ((ProjectorModuleType)entry.getKey()).shouldTickBlocks()).collect(Collectors.toSet());
            shape.doBlockEffect(pos -> {
                BlockState state = level.m_8055_(pos);
                Block block = state.m_60734_();
                if (block instanceof IBeamAffectEffect) {
                    ((IBeamAffectEffect)block).onBeamAffectTick(this, (BlockPos)pos, state);
                }
                blockModules.forEach(entry -> {
                    ProjectorModuleType type = (ProjectorModuleType)entry.getKey();
                    int count = (Integer)entry.getValue();
                    type.onBlockTick(this, (BlockPos)pos, count);
                    if (this.isVisualColliding((BlockPos)pos, state)) {
                        type.onCollisionTick(this, (BlockPos)pos, count);
                    }
                });
            });
            Set<Map.Entry> entities = this.modules.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0 && ((ProjectorModuleType)entry.getKey()).shouldTickEntities()).collect(Collectors.toSet());
            if (!entities.isEmpty()) {
                for (Entity entity : level.m_45933_((Entity)this, shape.getBounds())) {
                    if (!this.isColliding(entity)) continue;
                    entities.forEach(entry -> ((ProjectorModuleType)entry.getKey()).onEntityTick(this, entity, (Integer)entry.getValue()));
                }
            }
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        Vec3 end = this.getEnd();
        BlockPos endPos = new BlockPos((int)end.m_7096_(), (int)end.m_7098_(), (int)end.m_7094_());
        BlockState endState = this.m_9236_().m_8055_(endPos);
        Block endBlock = endState.m_60734_();
        if (endBlock instanceof IBeamCollisionEffect) {
            ((IBeamCollisionEffect)endBlock).onBeamStopCollision(this, endPos, endState);
        }
        this.getShape().doBlockEffect(pos -> {
            BlockState state = this.m_9236_().m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof IBeamAffectEffect) {
                ((IBeamAffectEffect)block).onBeamStopAffect(this, (BlockPos)pos, state);
            }
        });
        super.m_142687_(reason);
    }

    protected boolean isVisualColliding(BlockPos pos, BlockState state) {
        Cuboid shape = this.getShape();
        for (AABB bounds : state.m_60771_((BlockGetter)this.m_9236_(), pos, CollisionContext.m_82749_()).m_83299_()) {
            if (!shape.isColliding(bounds.m_82338_(pos))) continue;
            return true;
        }
        return false;
    }

    protected boolean isColliding(Entity entity) {
        return this.getShape().isColliding(entity.m_20191_());
    }

    @Nullable
    public UUID getDirectParent() {
        return this.parent;
    }

    public void setDirectParent(@Nullable UUID parent) {
        this.parent = parent;
    }

    public Set<UUID> getParents() {
        HashSet<UUID> parents = new HashSet<UUID>();
        UUID direct = this.getDirectParent();
        if (direct != null) {
            Entity parent;
            parents.add(direct);
            if (this.m_9236_() instanceof ServerLevel && (parent = ((ServerLevel)this.m_9236_()).m_8791_(direct)) instanceof BeamEntity) {
                parents.addAll(((BeamEntity)parent).getParents());
            }
        }
        return parents;
    }

    @Nullable
    public BlockPos getProjectorPos() {
        return this.projector;
    }

    public void setProjectorPos(@Nullable BlockPos projector) {
        this.projector = projector;
    }

    public Map<ProjectorModuleType, Integer> getModules() {
        return this.modules;
    }

    protected void setModules(Map<ProjectorModuleType, Integer> modules) {
        this.modules.clear();
        this.modules.putAll(modules);
    }

    protected void initializeModules() {
        this.getModules().forEach((module, amt) -> module.onStart(this, (int)amt));
    }

    public Vec3 getEnd() {
        SynchedEntityData manager = this.m_20088_();
        return new Vec3(((Double)manager.m_135370_(X)).doubleValue(), ((Double)manager.m_135370_(Y)).doubleValue(), ((Double)manager.m_135370_(Z)).doubleValue());
    }

    public void setEnd(Vec3 end, boolean start, boolean stop) {
        Vec3 before = this.getEnd();
        if (!end.equals((Object)before)) {
            Cuboid shape = this.getShape();
            this.setEndRaw(end);
            if (stop) {
                BlockPos beforePos = BlockPos.m_274446_((Position)before);
                BlockState beforeState = this.m_9236_().m_8055_(beforePos);
                Block beforeBlock = beforeState.m_60734_();
                if (beforeBlock instanceof IBeamCollisionEffect) {
                    ((IBeamCollisionEffect)beforeBlock).onBeamStopCollision(this, beforePos, beforeState);
                }
                shape.doBlockEffect(pos -> {
                    BlockState state = this.m_9236_().m_8055_(pos);
                    Block block = state.m_60734_();
                    if (block instanceof IBeamAffectEffect) {
                        ((IBeamAffectEffect)block).onBeamStopAffect(this, (BlockPos)pos, state);
                    }
                });
            }
            double length = end.m_82546_(this.m_20182_()).m_82553_();
            double growthRate = BeamEntity.getGrowthRate(this.getModules());
            this.setEndWidth(this.getStartWidth() + growthRate * length);
            this.setEndHeight(this.getStartHeight() + growthRate * length);
            if (start) {
                BlockPos afterPos = BlockPos.m_274446_((Position)end);
                BlockState afterState = this.m_9236_().m_8055_(afterPos);
                Block afterBlock = afterState.m_60734_();
                if (afterBlock instanceof IBeamCollisionEffect) {
                    ((IBeamCollisionEffect)afterBlock).onBeamStartCollision(this, afterPos, afterState);
                }
            }
        }
    }

    public void setEndRaw(Vec3 end) {
        SynchedEntityData manager = this.m_20088_();
        manager.m_135381_(X, (Object)end.m_7096_());
        manager.m_135381_(Y, (Object)end.m_7098_());
        manager.m_135381_(Z, (Object)end.m_7094_());
        this.refreshShape();
    }

    public double getStartWidth() {
        return (Double)this.m_20088_().m_135370_(START_WIDTH);
    }

    public void setStartWidth(double width) {
        this.m_20088_().m_135381_(START_WIDTH, (Object)width);
        this.refreshShape();
    }

    public double getStartHeight() {
        return (Double)this.m_20088_().m_135370_(START_HEIGHT);
    }

    public void setStartHeight(double height) {
        this.m_20088_().m_135381_(START_HEIGHT, (Object)height);
        this.refreshShape();
    }

    public double getEndWidth() {
        return (Double)this.m_20088_().m_135370_(END_WIDTH);
    }

    public void setEndWidth(double width) {
        this.m_20088_().m_135381_(END_WIDTH, (Object)width);
        this.refreshShape();
    }

    public double getEndHeight() {
        return (Double)this.m_20088_().m_135370_(END_HEIGHT);
    }

    public void setEndHeight(double height) {
        this.m_20088_().m_135381_(END_HEIGHT, (Object)height);
        this.refreshShape();
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_(x, y, z);
        this.refreshShape();
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    public void setColor(int color) {
        this.m_20088_().m_135381_(COLOR, (Object)color);
    }

    public int getLayers() {
        return (Integer)this.m_20088_().m_135370_(LAYERS);
    }

    public void setLayers(int layers) {
        this.m_20088_().m_135381_(LAYERS, (Object)layers);
    }

    @Nullable
    public UUID getShooter() {
        return this.shooter;
    }

    public void setShooter(@Nullable UUID shooter) {
        this.shooter = shooter;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public void setLifespan(int lifespan) {
        this.lifespan = lifespan;
    }

    public Cuboid getShape() {
        if (this.shape == null) {
            this.shape = Cuboid.fromBeam(this);
        }
        return this.shape;
    }

    protected void refreshShape() {
        this.shape = null;
    }

    protected void m_8097_() {
        SynchedEntityData manager = this.m_20088_();
        manager.m_135372_(X, (Object)0.0);
        manager.m_135372_(Y, (Object)0.0);
        manager.m_135372_(Z, (Object)0.0);
        manager.m_135372_(START_WIDTH, (Object)1.0);
        manager.m_135372_(START_HEIGHT, (Object)1.0);
        manager.m_135372_(END_WIDTH, (Object)1.0);
        manager.m_135372_(END_HEIGHT, (Object)1.0);
        manager.m_135372_(COLOR, (Object)0x40FFFFFF);
        manager.m_135372_(LAYERS, (Object)1);
    }

    public AABB m_6921_() {
        return this.getShape().getBounds();
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("EndX", 6) && tag.m_128425_("EndY", 6) && tag.m_128425_("EndZ", 6)) {
            this.setEndRaw(new Vec3(tag.m_128459_("EndX"), tag.m_128459_("EndY"), tag.m_128459_("EndZ")));
        }
        if (tag.m_128425_("ProjectorX", 3) && tag.m_128425_("ProjectorY", 3) && tag.m_128425_("ProjectorZ", 3)) {
            this.setProjectorPos(new BlockPos(tag.m_128451_("ProjectorX"), tag.m_128451_("ProjectorY"), tag.m_128451_("ProjectorZ")));
        }
        if (tag.m_128425_("StartWidth", 6)) {
            this.setStartWidth(tag.m_128459_("StartWidth"));
        }
        if (tag.m_128425_("StartHeight", 6)) {
            this.setStartHeight(tag.m_128459_("StartHeight"));
        }
        if (tag.m_128425_("EndWidth", 6)) {
            this.setEndWidth(tag.m_128459_("EndWidth"));
        }
        if (tag.m_128425_("EndHeight", 6)) {
            this.setEndHeight(tag.m_128459_("EndHeight"));
        }
        if (tag.m_128425_("Color", 3)) {
            this.setColor(tag.m_128451_("Color"));
        }
        if (tag.m_128425_("Layers", 3)) {
            this.setLayers(tag.m_128451_("Layers"));
        }
        if (tag.m_128425_("Lifespan", 3)) {
            this.setLifespan(tag.m_128451_("Lifespan"));
        }
        if (tag.m_128425_("Parent", 11)) {
            this.setDirectParent(tag.m_128342_("Parent"));
        }
        if (tag.m_128425_("Shooter", 11)) {
            this.setShooter(tag.m_128342_("Shooter"));
        }
        if (tag.m_128425_("MaxRange", 6)) {
            this.setMaxRange(tag.m_128459_("MaxRange"));
        }
        if (tag.m_128425_("Modules", 10)) {
            HashMap<ProjectorModuleType, Integer> modules = new HashMap<ProjectorModuleType, Integer>();
            IForgeRegistry<ProjectorModuleType> registry = ProjectorModuleRegistry.getRegistry();
            CompoundTag map = tag.m_128469_("Modules");
            for (String key : map.m_128431_()) {
                ProjectorModuleType type = (ProjectorModuleType)registry.getValue(new ResourceLocation(key));
                if (type == null || !map.m_128425_(key, 3)) continue;
                modules.put(type, map.m_128451_(key));
            }
            this.setModules(modules);
        }
    }

    protected void m_7380_(CompoundTag tag) {
        BlockPos projector;
        UUID shooter;
        Vec3 end = this.getEnd();
        tag.m_128347_("EndX", end.m_7096_());
        tag.m_128347_("EndY", end.m_7098_());
        tag.m_128347_("EndZ", end.m_7094_());
        tag.m_128347_("StartWidth", this.getStartWidth());
        tag.m_128347_("StartHeight", this.getStartHeight());
        tag.m_128347_("EndWidth", this.getEndWidth());
        tag.m_128347_("EndHeight", this.getEndHeight());
        tag.m_128405_("Color", this.getColor());
        tag.m_128405_("Layers", this.getLayers());
        tag.m_128405_("Lifespan", this.getLifespan());
        tag.m_128347_("MaxRange", this.getMaxRange());
        UUID parent = this.getDirectParent();
        if (parent != null) {
            tag.m_128362_("Parent", parent);
        }
        if ((shooter = this.getShooter()) != null) {
            tag.m_128362_("Shooter", shooter);
        }
        if ((projector = this.getProjectorPos()) != null) {
            tag.m_128405_("ProjectorX", projector.m_123341_());
            tag.m_128405_("ProjectorY", projector.m_123342_());
            tag.m_128405_("ProjectorZ", projector.m_123343_());
        }
        CompoundTag modules = new CompoundTag();
        IForgeRegistry<ProjectorModuleType> registry = ProjectorModuleRegistry.getRegistry();
        this.modules.forEach((type, amt) -> modules.m_128405_(registry.getKey(type).toString(), amt.intValue()));
        tag.m_128365_("Modules", (Tag)modules);
    }

    public boolean m_6783_(double distSq) {
        double range = 64.0 * BeamEntity.m_20150_();
        return distSq < range * range;
    }
}

