/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.beams.common.entities;

import io.github.davidqf555.minecraft.beams.common.entities.BeamEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Cuboid {
    private final Vec3[] vertices;
    private final ConvexQuadrilateral3D[] sides;
    private ConvexPolygon2D[] slices;
    private AABB bounds;

    public Cuboid(Vec3[] vertices, ConvexQuadrilateral3D[] sides) {
        this.vertices = vertices;
        this.sides = sides;
    }

    public static Cuboid fromBeam(BeamEntity beam) {
        Vec3 start = beam.m_20182_();
        Vec3 end = beam.getEnd();
        Vec3 center = end.m_82546_(start).m_82541_();
        Vec3 horizontal = center.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        if (horizontal.m_82556_() == 0.0) {
            horizontal = new Vec3(0.0, 0.0, 1.0);
        }
        Vec3 vertical = horizontal.m_82537_(center);
        Vec3[] vertices = new Vec3[8];
        double startWidth = beam.getStartWidth();
        double startHeight = beam.getStartHeight();
        double endWidth = beam.getEndWidth();
        double endHeight = beam.getEndHeight();
        vertices[0] = start.m_82549_(horizontal.m_82490_(startWidth / 2.0)).m_82549_(vertical.m_82490_(startHeight / 2.0));
        vertices[1] = start.m_82549_(horizontal.m_82490_(startWidth / 2.0)).m_82546_(vertical.m_82490_(startHeight / 2.0));
        vertices[2] = start.m_82546_(horizontal.m_82490_(startWidth / 2.0)).m_82546_(vertical.m_82490_(startHeight / 2.0));
        vertices[3] = start.m_82546_(horizontal.m_82490_(startWidth / 2.0)).m_82549_(vertical.m_82490_(startHeight / 2.0));
        vertices[4] = end.m_82549_(horizontal.m_82490_(endWidth / 2.0)).m_82549_(vertical.m_82490_(endHeight / 2.0));
        vertices[5] = end.m_82549_(horizontal.m_82490_(endWidth / 2.0)).m_82546_(vertical.m_82490_(endHeight / 2.0));
        vertices[6] = end.m_82546_(horizontal.m_82490_(endWidth / 2.0)).m_82546_(vertical.m_82490_(endHeight / 2.0));
        vertices[7] = end.m_82546_(horizontal.m_82490_(endWidth / 2.0)).m_82549_(vertical.m_82490_(endHeight / 2.0));
        ConvexQuadrilateral3D[] sides = new ConvexQuadrilateral3D[]{new ConvexQuadrilateral3D(new Vec3[][]{{vertices[0], vertices[2]}, {vertices[1], vertices[3]}}, center.m_82548_()), new ConvexQuadrilateral3D(new Vec3[][]{{vertices[4], vertices[6]}, {vertices[5], vertices[7]}}, center), new ConvexQuadrilateral3D(new Vec3[][]{{vertices[0], vertices[7]}, {vertices[3], vertices[4]}}, vertices[4].m_82546_(vertices[0]).m_82537_(horizontal.m_82548_()).m_82541_()), new ConvexQuadrilateral3D(new Vec3[][]{{vertices[2], vertices[5]}, {vertices[1], vertices[6]}}, vertices[6].m_82546_(vertices[2]).m_82537_(horizontal).m_82541_()), new ConvexQuadrilateral3D(new Vec3[][]{{vertices[2], vertices[7]}, {vertices[3], vertices[6]}}, vertices[6].m_82546_(vertices[2]).m_82537_(vertical.m_82548_()).m_82541_()), new ConvexQuadrilateral3D(new Vec3[][]{{vertices[4], vertices[1]}, {vertices[0], vertices[5]}}, vertices[4].m_82546_(vertices[0]).m_82537_(vertical).m_82541_())};
        return new Cuboid(vertices, sides);
    }

    private static ConvexPolygon2D calculateConvexHull(List<Point2D> points) {
        List<Point2D> hull = Cuboid.grahamScan(points);
        hull.remove(hull.size() - 1);
        return new ConvexPolygon2D(hull.toArray(new Point2D[0]));
    }

    private static List<Point2D> grahamScan(List<Point2D> points) {
        Point2D p = (Point2D)points.stream().min((p1, p2) -> {
            if (p1.y != p2.y) {
                return Double.compare(p1.y, p2.y);
            }
            return Double.compare(p1.x, p2.x);
        }).orElseThrow(IllegalArgumentException::new);
        points.sort((p1, p2) -> {
            double dX1 = p1.x - p.x;
            double dY2 = p2.y - p.y;
            double dX2 = p2.x - p.x;
            double dY1 = p1.y - p.y;
            double cross = dX1 * dY2 - dX2 * dY1;
            if (cross == 0.0) {
                return dX1 == dX2 ? Double.compare(dY1, dY2) : Double.compare(Math.abs(dX1), Math.abs(dX2));
            }
            return cross < 0.0 ? 1 : -1;
        });
        points.add(p);
        ArrayList<Point2D> hull = new ArrayList<Point2D>();
        block0: for (Point2D point : points) {
            hull.add(point);
            while (hull.size() >= 3) {
                Point2D prev1 = (Point2D)hull.get(hull.size() - 2);
                Point2D prev2 = (Point2D)hull.get(hull.size() - 3);
                double cross = (prev1.x - prev2.x) * (point.y - prev2.y) - (prev1.y - prev2.y) * (point.x - prev2.x);
                if (cross == 0.0) {
                    hull.remove(hull.size() - 2);
                    continue block0;
                }
                if (cross > 0.0) continue block0;
                hull.remove(hull.size() - 2);
            }
        }
        return hull;
    }

    public void doBlockEffect(Consumer<BlockPos> effect) {
        int startY = Mth.m_14107_((double)this.getBounds().f_82289_);
        ConvexPolygon2D[] slices = this.getSlices();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < slices.length; ++i) {
            if (slices[i] == null) continue;
            pos.m_142448_(startY + i);
            slices[i].doEffect((x, z) -> {
                pos.m_142451_(x.intValue());
                pos.m_142443_(z.intValue());
                effect.accept((BlockPos)pos);
            });
        }
    }

    public boolean isColliding(AABB bounds) {
        for (Vec3 vec3 : new Vec3[]{new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82290_), new Vec3(bounds.f_82288_, bounds.f_82289_, bounds.f_82293_), new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82290_), new Vec3(bounds.f_82288_, bounds.f_82292_, bounds.f_82293_), new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82290_), new Vec3(bounds.f_82291_, bounds.f_82289_, bounds.f_82293_), new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82290_), new Vec3(bounds.f_82291_, bounds.f_82292_, bounds.f_82293_)}) {
            if (!this.isColliding(vec3)) continue;
            return true;
        }
        for (ConvexQuadrilateral3D convexQuadrilateral3D : this.sides) {
            for (Vec3 start : convexQuadrilateral3D.vertices[0]) {
                for (Vec3 end : convexQuadrilateral3D.vertices[1]) {
                    if (!bounds.m_82371_(start, end).isPresent()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isColliding(Vec3 pos) {
        for (ConvexQuadrilateral3D side : this.sides) {
            Vec3 dir = side.vertices[0][0].m_82546_(pos).m_82541_();
            if (!(dir.m_82526_(side.normal) < 0.0)) continue;
            return false;
        }
        return true;
    }

    public AABB getBounds() {
        if (this.bounds == null) {
            double minX = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            double minY = Double.MAX_VALUE;
            double maxY = -1.7976931348623157E308;
            double minZ = Double.MAX_VALUE;
            double maxZ = -1.7976931348623157E308;
            for (Vec3 vertex : this.vertices) {
                if (vertex.m_7096_() > maxX) {
                    maxX = vertex.m_7096_();
                }
                if (vertex.m_7096_() < minX) {
                    minX = vertex.m_7096_();
                }
                if (vertex.m_7098_() > maxY) {
                    maxY = vertex.m_7098_();
                }
                if (vertex.m_7098_() < minY) {
                    minY = vertex.m_7098_();
                }
                if (vertex.m_7094_() > maxZ) {
                    maxZ = vertex.m_7094_();
                }
                if (!(vertex.m_7094_() < minZ)) continue;
                minZ = vertex.m_7094_();
            }
            this.bounds = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        }
        return this.bounds;
    }

    private ConvexPolygon2D[] getSlices() {
        if (this.slices == null) {
            this.slices = this.calculateSlices();
        }
        return this.slices;
    }

    private ConvexPolygon2D[] calculateSlices() {
        AABB bounds = this.getBounds();
        ConvexPolygon2D[] slices = new ConvexPolygon2D[Mth.m_14107_((double)bounds.f_82292_) - Mth.m_14107_((double)bounds.f_82289_) + 1];
        double[] heights = Arrays.stream(this.vertices).mapToDouble(Vec3::m_7098_).sorted().distinct().toArray();
        int index = 0;
        for (int i = 0; i < slices.length; ++i) {
            ArrayList<Double> crit = new ArrayList<Double>();
            int low = Mth.m_14107_((double)bounds.f_82289_) + i;
            if ((double)low >= bounds.f_82289_) {
                crit.add(Double.valueOf(low));
            }
            int high = low + 1;
            while (index < heights.length && heights[index] < (double)high) {
                crit.add(heights[index]);
                ++index;
            }
            if ((double)high <= bounds.f_82292_) {
                crit.add(Double.valueOf(high));
            }
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            Iterator iterator = crit.iterator();
            while (iterator.hasNext()) {
                double val = (Double)iterator.next();
                for (ConvexQuadrilateral3D side : this.sides) {
                    if (!side.within(val)) continue;
                    points.addAll(side.edgeIntersection(val));
                }
            }
            if (points.isEmpty()) continue;
            slices[i] = Cuboid.calculateConvexHull(points);
        }
        return slices;
    }

    public static class ConvexQuadrilateral3D {
        private final Vec3[][] vertices;
        private final Vec3 normal;

        public ConvexQuadrilateral3D(Vec3[][] vertices, Vec3 normal) {
            this.vertices = vertices;
            this.normal = normal;
        }

        private Set<Point2D> edgeIntersection(double y) {
            HashSet<Point2D> points = new HashSet<Point2D>();
            for (Vec3 v1 : this.vertices[0]) {
                for (Vec3 v2 : this.vertices[1]) {
                    if (Math.min(v1.f_82480_, v2.f_82480_) > y || Math.max(v1.f_82480_, v2.f_82480_) < y) continue;
                    if (v1.f_82480_ == v2.f_82480_) {
                        points.add(new Point2D(v1.f_82479_, v1.f_82481_));
                        points.add(new Point2D(v2.f_82479_, v2.f_82481_));
                        continue;
                    }
                    if (v1.f_82479_ == v2.f_82479_) {
                        double z = v1.f_82481_ + (v2.f_82481_ - v1.f_82481_) * (y - v1.f_82480_) / (v2.f_82480_ - v1.f_82480_);
                        points.add(new Point2D(v1.f_82479_, z));
                        continue;
                    }
                    double x = v1.f_82479_ + (v2.f_82479_ - v1.f_82479_) * (y - v1.f_82480_) / (v2.f_82480_ - v1.f_82480_);
                    double z = v1.f_82481_ + (v2.f_82481_ - v1.f_82481_) * (x - v1.f_82479_) / (v2.f_82479_ - v1.f_82479_);
                    points.add(new Point2D(x, z));
                }
            }
            return points;
        }

        private boolean within(double y) {
            boolean min = false;
            boolean max = false;
            Vec3[][] vec3Array = this.vertices;
            int n = vec3Array.length;
            for (int i = 0; i < n; ++i) {
                Vec3[] points;
                for (Vec3 point : points = vec3Array[i]) {
                    if (point.m_7098_() >= y) {
                        max = true;
                    }
                    if (!(point.m_7098_() <= y)) continue;
                    min = true;
                }
            }
            return min && max;
        }
    }

    private static class ConvexPolygon2D {
        private final LineSegment2D[] lines;
        private final double[] x;

        private ConvexPolygon2D(Point2D[] vertices) {
            this.lines = new LineSegment2D[vertices.length];
            this.x = new double[vertices.length];
            for (int i = 0; i < this.lines.length - 1; ++i) {
                this.lines[i] = new LineSegment2D(vertices[i], vertices[i + 1]);
                this.x[i] = vertices[i].x;
            }
            this.lines[this.lines.length - 1] = new LineSegment2D(vertices[this.lines.length - 1], vertices[0]);
            this.x[vertices.length - 1] = vertices[vertices.length - 1].x;
            Arrays.sort(this.x);
        }

        public void doEffect(BiConsumer<Integer, Integer> effect) {
            int index = 0;
            int x = Mth.m_14107_((double)this.x[0]);
            while ((double)x <= this.x[this.x.length - 1]) {
                HashSet<Double> crit = new HashSet<Double>();
                crit.add(Double.valueOf(x));
                crit.add((double)x + 1.0);
                while (index < this.x.length && this.x[index] < (double)(x + 1)) {
                    crit.add(this.x[index]);
                    ++index;
                }
                for (double add : this.x) {
                    if (!(add >= (double)x) || !(add < (double)(x + 1))) continue;
                    crit.add(add);
                }
                boolean found = false;
                double min = Double.MAX_VALUE;
                double max = -1.7976931348623157E308;
                for (LineSegment2D line : this.lines) {
                    Iterator iterator = crit.iterator();
                    while (iterator.hasNext()) {
                        double val = (Double)iterator.next();
                        if (!line.within(val)) continue;
                        double y = line.getY(val);
                        if (y < min) {
                            min = y;
                        }
                        if (y > max) {
                            max = y;
                        }
                        found = true;
                    }
                }
                if (found) {
                    int y = Mth.m_14107_((double)min);
                    while ((double)y <= max) {
                        effect.accept(x, y);
                        ++y;
                    }
                }
                ++x;
            }
        }
    }

    private static class Point2D {
        private final double x;
        private final double y;

        private Point2D(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            return obj instanceof Point2D && ((Point2D)obj).x == this.x && ((Point2D)obj).y == this.y;
        }

        public int hashCode() {
            return Double.hashCode(this.x) + Double.hashCode(this.y);
        }
    }

    private static class LineSegment2D {
        private final Point2D start;
        private final Point2D end;
        private final double slope;

        private LineSegment2D(Point2D start, Point2D end) {
            this.start = start;
            this.end = end;
            this.slope = (end.y - start.y) / (end.x - start.x);
        }

        private double getY(double x) {
            return this.start.y + this.slope * (x - this.start.x);
        }

        private boolean within(double x) {
            return x >= Math.min(this.start.x, this.end.x) && x <= Math.max(this.start.x, this.end.x);
        }
    }
}

